/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

class ChannelFlushContext {
    private final String name;
    private final String fullyQualifiedName;
    private final String dbName;
    private final String schemaName;
    private final String tableName;
    private final String fullyQualifiedTableName;
    private final Long channelSequencer;
    private final String encryptionKey;
    private final Long encryptionKeyId;

    ChannelFlushContext(String name, String dbName, String schemaName, String tableName, Long channelSequencer, String encryptionKey, Long encryptionKeyId) {
        this.name = name;
        this.fullyQualifiedName = String.format("%s.%s.%s.%s", dbName, schemaName, tableName, name);
        this.dbName = dbName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.fullyQualifiedTableName = String.format("%s.%s.%s", this.getDbName(), this.getSchemaName(), this.getTableName());
        this.channelSequencer = channelSequencer;
        this.encryptionKey = encryptionKey;
        this.encryptionKeyId = encryptionKeyId;
    }

    public String toString() {
        return "ChannelContext{name='" + this.getName() + '\'' + ", fullyQualifiedName='" + this.getFullyQualifiedName() + '\'' + ", dbName='" + this.getDbName() + '\'' + ", schemaName='" + this.getSchemaName() + '\'' + ", tableName='" + this.getTableName() + '\'' + ", fullyQualifiedTableName='" + this.getFullyQualifiedTableName() + '\'' + ", channelSequencer=" + this.getChannelSequencer() + ", encryptionKey='" + this.getEncryptionKey() + '\'' + ", encryptionKeyId=" + this.getEncryptionKeyId() + '}';
    }

    String getName() {
        return this.name;
    }

    String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    String getDbName() {
        return this.dbName;
    }

    String getSchemaName() {
        return this.schemaName;
    }

    String getTableName() {
        return this.tableName;
    }

    String getFullyQualifiedTableName() {
        return this.fullyQualifiedTableName;
    }

    Long getChannelSequencer() {
        return this.channelSequencer;
    }

    String getEncryptionKey() {
        return this.encryptionKey;
    }

    Long getEncryptionKeyId() {
        return this.encryptionKeyId;
    }
}

