/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.SFException;

class RowBufferStats {
    private final int ordinal;
    private byte[] currentMinStrValue;
    private byte[] currentMaxStrValue;
    private BigInteger currentMinIntValue;
    private BigInteger currentMaxIntValue;
    private Double currentMinRealValue;
    private Double currentMaxRealValue;
    private long currentNullCount;
    private long currentMaxLength;
    private final String collationDefinitionString;
    private final String columnDisplayName;

    RowBufferStats(String columnDisplayName, String collationDefinitionString, int ordinal) {
        this.columnDisplayName = columnDisplayName;
        this.collationDefinitionString = collationDefinitionString;
        this.ordinal = ordinal;
        this.reset();
    }

    RowBufferStats(String columnDisplayName) {
        this(columnDisplayName, null, -1);
    }

    void reset() {
        this.currentMaxStrValue = null;
        this.currentMinStrValue = null;
        this.currentMaxIntValue = null;
        this.currentMinIntValue = null;
        this.currentMaxRealValue = null;
        this.currentMinRealValue = null;
        this.currentNullCount = 0L;
        this.currentMaxLength = 0L;
    }

    RowBufferStats forkEmpty() {
        return new RowBufferStats(this.getColumnDisplayName(), this.getCollationDefinitionString(), this.getOrdinal());
    }

    static RowBufferStats getCombinedStats(RowBufferStats left, RowBufferStats right) {
        if (!Objects.equals(left.getCollationDefinitionString(), right.collationDefinitionString)) {
            throw new SFException(ErrorCode.INVALID_COLLATION_STRING, "Tried to combine stats for different collations", String.format("left=%s, right=%s", left.getCollationDefinitionString(), right.getCollationDefinitionString()));
        }
        RowBufferStats combined = new RowBufferStats(left.columnDisplayName, left.getCollationDefinitionString(), left.getOrdinal());
        if (left.currentMinIntValue != null) {
            combined.addIntValue(left.currentMinIntValue);
            combined.addIntValue(left.currentMaxIntValue);
        }
        if (right.currentMinIntValue != null) {
            combined.addIntValue(right.currentMinIntValue);
            combined.addIntValue(right.currentMaxIntValue);
        }
        if (left.currentMinStrValue != null) {
            combined.addBinaryValue(left.currentMinStrValue);
            combined.addBinaryValue(left.currentMaxStrValue);
        }
        if (right.currentMinStrValue != null) {
            combined.addBinaryValue(right.currentMinStrValue);
            combined.addBinaryValue(right.currentMaxStrValue);
        }
        if (left.currentMinRealValue != null) {
            combined.addRealValue(left.currentMinRealValue);
            combined.addRealValue(left.currentMaxRealValue);
        }
        if (right.currentMinRealValue != null) {
            combined.addRealValue(right.currentMinRealValue);
            combined.addRealValue(right.currentMaxRealValue);
        }
        combined.currentNullCount = left.currentNullCount + right.currentNullCount;
        combined.currentMaxLength = Math.max(left.currentMaxLength, right.currentMaxLength);
        return combined;
    }

    void addStrValue(String value) {
        this.addBinaryValue(value.getBytes(StandardCharsets.UTF_8));
    }

    void addBinaryValue(byte[] valueBytes) {
        this.setCurrentMaxLength(valueBytes.length);
        if (this.currentMinStrValue == null) {
            this.currentMinStrValue = valueBytes;
            this.currentMaxStrValue = valueBytes;
        } else if (RowBufferStats.compareUnsigned(this.currentMinStrValue, valueBytes) > 0) {
            this.currentMinStrValue = valueBytes;
        } else if (RowBufferStats.compareUnsigned(this.currentMaxStrValue, valueBytes) < 0) {
            this.currentMaxStrValue = valueBytes;
        }
    }

    byte[] getCurrentMinStrValue() {
        return this.currentMinStrValue;
    }

    byte[] getCurrentMaxStrValue() {
        return this.currentMaxStrValue;
    }

    void addIntValue(BigInteger value) {
        if (this.currentMinIntValue == null) {
            this.currentMinIntValue = value;
            this.currentMaxIntValue = value;
        } else if (this.currentMinIntValue.compareTo(value) > 0) {
            this.currentMinIntValue = value;
        } else if (this.currentMaxIntValue.compareTo(value) < 0) {
            this.currentMaxIntValue = value;
        }
    }

    BigInteger getCurrentMinIntValue() {
        return this.currentMinIntValue;
    }

    BigInteger getCurrentMaxIntValue() {
        return this.currentMaxIntValue;
    }

    void addRealValue(Double value) {
        if (this.currentMinRealValue == null) {
            this.currentMinRealValue = value;
            this.currentMaxRealValue = value;
        } else if (this.currentMinRealValue.compareTo(value) > 0) {
            this.currentMinRealValue = value;
        } else if (this.currentMaxRealValue.compareTo(value) < 0) {
            this.currentMaxRealValue = value;
        }
    }

    Double getCurrentMinRealValue() {
        return this.currentMinRealValue;
    }

    Double getCurrentMaxRealValue() {
        return this.currentMaxRealValue;
    }

    void incCurrentNullCount() {
        ++this.currentNullCount;
    }

    long getCurrentNullCount() {
        return this.currentNullCount;
    }

    void setCurrentMaxLength(long currentMaxLength) {
        if (currentMaxLength > this.currentMaxLength) {
            this.currentMaxLength = currentMaxLength;
        }
    }

    long getCurrentMaxLength() {
        return this.currentMaxLength;
    }

    long getDistinctValues() {
        return -1L;
    }

    String getCollationDefinitionString() {
        return this.collationDefinitionString;
    }

    String getColumnDisplayName() {
        return this.columnDisplayName;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    static int compareUnsigned(byte[] a, byte[] b) {
        if (a == b) {
            return 0;
        }
        for (int mismatchIdx = 0; mismatchIdx < Math.min(a.length, b.length); ++mismatchIdx) {
            if (a[mismatchIdx] == b[mismatchIdx]) continue;
            return Byte.toUnsignedInt(a[mismatchIdx]) - Byte.toUnsignedInt(b[mismatchIdx]);
        }
        return a.length - b.length;
    }
}

