/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeFileTransferConfig;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadata;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadataV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.client.jdbc.internal.apache.commons.io.FileUtils;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ObjectNode;
import net.snowflake.ingest.connection.IngestResponseException;
import net.snowflake.ingest.connection.RequestBuilder;
import net.snowflake.ingest.connection.ServiceResponseHandler;
import net.snowflake.ingest.internal.com.google.common.annotations.VisibleForTesting;
import net.snowflake.ingest.streaming.internal.StreamingIngestUtils;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.HttpUtil;
import net.snowflake.ingest.utils.Logging;
import net.snowflake.ingest.utils.SFException;
import net.snowflake.ingest.utils.Utils;

class StreamingIngestStage {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final long REFRESH_THRESHOLD_IN_MS = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES);
    private static final Logging logger = new Logging(StreamingIngestStage.class);
    private SnowflakeFileTransferMetadataWithAge fileTransferMetadataWithAge;
    private final CloseableHttpClient httpClient;
    private final RequestBuilder requestBuilder;
    private final String role;
    private final String clientName;
    private String clientPrefix;
    private final int maxUploadRetries;
    private final Properties proxyProperties;
    private static final MapStatusGetter statusGetter = new MapStatusGetter();

    StreamingIngestStage(boolean isTestMode, String role, CloseableHttpClient httpClient, RequestBuilder requestBuilder, String clientName, int maxUploadRetries) throws SnowflakeSQLException, IOException {
        this.httpClient = httpClient;
        this.role = role;
        this.requestBuilder = requestBuilder;
        this.clientName = clientName;
        this.proxyProperties = HttpUtil.generateProxyPropertiesForJDBC();
        this.maxUploadRetries = maxUploadRetries;
        if (!isTestMode) {
            this.refreshSnowflakeMetadata();
        }
    }

    StreamingIngestStage(boolean isTestMode, String role, CloseableHttpClient httpClient, RequestBuilder requestBuilder, String clientName, SnowflakeFileTransferMetadataWithAge testMetadata, int maxRetryCount) throws SnowflakeSQLException, IOException {
        this(isTestMode, role, httpClient, requestBuilder, clientName, maxRetryCount);
        if (!isTestMode) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, new Object[0]);
        }
        this.fileTransferMetadataWithAge = testMetadata;
    }

    void putRemote(String fullFilePath, byte[] data) throws SnowflakeSQLException, IOException {
        this.putRemote(fullFilePath, data, 0);
    }

    private void putRemote(String fullFilePath, byte[] data, int retryCount) throws SnowflakeSQLException, IOException {
        SnowflakeFileTransferMetadataV1 fileTransferMetadataCopy;
        if (this.fileTransferMetadataWithAge.fileTransferMetadata.isForOneFile()) {
            fileTransferMetadataCopy = this.fetchSignedURL(fullFilePath);
        } else {
            SnowflakeFileTransferMetadataV1 fileTransferMetadata = this.fileTransferMetadataWithAge.fileTransferMetadata;
            fileTransferMetadataCopy = new SnowflakeFileTransferMetadataV1(fileTransferMetadata.getPresignedUrl(), fullFilePath, fileTransferMetadata.getEncryptionMaterial() != null ? fileTransferMetadata.getEncryptionMaterial().getQueryStageMasterKey() : null, fileTransferMetadata.getEncryptionMaterial() != null ? fileTransferMetadata.getEncryptionMaterial().getQueryId() : null, fileTransferMetadata.getEncryptionMaterial() != null ? fileTransferMetadata.getEncryptionMaterial().getSmkId() : null, fileTransferMetadata.getCommandType(), fileTransferMetadata.getStageInfo());
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(data);
        try {
            SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata((SnowflakeFileTransferMetadata)fileTransferMetadataCopy).setUploadStream((InputStream)inStream).setRequireCompress(false).setOcspMode(OCSPMode.FAIL_OPEN).setStreamingIngestClientKey(this.clientPrefix).setStreamingIngestClientName(this.clientName).setProxyProperties(this.proxyProperties).setDestFileName(fullFilePath).build());
        }
        catch (Exception e) {
            if (retryCount == 0) {
                logger.logInfo("Stage metadata need to be refreshed due to upload error: {} on first retry attempt", e.getMessage());
                this.refreshSnowflakeMetadata();
            }
            if (retryCount >= this.maxUploadRetries) {
                logger.logError("Failed to upload to stage, retry attempts exhausted ({}), client={}, message={}", this.maxUploadRetries, this.clientName, e.getMessage());
                throw new SFException(e, ErrorCode.IO_ERROR, new Object[0]);
            }
            StreamingIngestUtils.sleepForRetry(++retryCount);
            logger.logInfo("Retrying upload, attempt {}/{} msg: {}, stackTrace:{}", retryCount, this.maxUploadRetries, e.getMessage(), Utils.getStackTrace(e));
            this.putRemote(fullFilePath, data, retryCount);
        }
    }

    SnowflakeFileTransferMetadataWithAge refreshSnowflakeMetadata() throws SnowflakeSQLException, IOException {
        logger.logInfo("Refresh Snowflake metadata, client={}", this.clientName);
        return this.refreshSnowflakeMetadata(false);
    }

    synchronized SnowflakeFileTransferMetadataWithAge refreshSnowflakeMetadata(boolean force) throws SnowflakeSQLException, IOException {
        if (!force && this.fileTransferMetadataWithAge != null && this.fileTransferMetadataWithAge.timestamp.isPresent() && this.fileTransferMetadataWithAge.timestamp.get() > System.currentTimeMillis() - REFRESH_THRESHOLD_IN_MS) {
            return this.fileTransferMetadataWithAge;
        }
        HashMap<Object, Object> payload = new HashMap<Object, Object>();
        payload.put("role", this.role);
        Map<String, Object> response = this.makeClientConfigureCall(payload);
        JsonNode responseNode = this.parseClientConfigureResponse(response);
        if (Utils.isNullOrEmpty(this.clientPrefix)) {
            this.clientPrefix = this.createClientPrefix(responseNode);
        }
        Utils.assertStringNotNullOrEmpty("client prefix", this.clientPrefix);
        this.fileTransferMetadataWithAge = responseNode.get("data").get("stageInfo").get("locationType").toString().replaceAll("^[\"]|[\"]$", "").equals(StageInfo.StageType.LOCAL_FS.name()) ? new SnowflakeFileTransferMetadataWithAge(responseNode.get("data").get("stageInfo").get("location").toString().replaceAll("^[\"]|[\"]$", ""), Optional.of(System.currentTimeMillis())) : new SnowflakeFileTransferMetadataWithAge((SnowflakeFileTransferMetadataV1)SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)responseNode).get(0), Optional.of(System.currentTimeMillis()));
        return this.fileTransferMetadataWithAge;
    }

    private String createClientPrefix(JsonNode response) {
        String prefix = response.get("prefix").textValue();
        String deploymentId = response.has("deployment_id") ? "_" + response.get("deployment_id").longValue() : "";
        return prefix + deploymentId;
    }

    SnowflakeFileTransferMetadataV1 fetchSignedURL(String fileName) throws SnowflakeSQLException, IOException {
        HashMap<Object, Object> payload = new HashMap<Object, Object>();
        payload.put("role", this.role);
        payload.put("file_name", fileName);
        Map<String, Object> response = this.makeClientConfigureCall(payload);
        JsonNode responseNode = this.parseClientConfigureResponse(response);
        SnowflakeFileTransferMetadataV1 metadata = (SnowflakeFileTransferMetadataV1)SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)responseNode).get(0);
        metadata.setPresignedUrlFileName(fileName);
        return metadata;
    }

    private JsonNode parseClientConfigureResponse(Map<String, Object> response) {
        JsonNode responseNode = mapper.valueToTree(response);
        ObjectNode mutable = (ObjectNode)responseNode;
        mutable.putObject("data");
        ObjectNode dataNode = (ObjectNode)mutable.get("data");
        dataNode.set("stageInfo", responseNode.get("stage_location"));
        dataNode.putArray("src_locations").add("placeholder");
        return responseNode;
    }

    private Map<String, Object> makeClientConfigureCall(Map<Object, Object> payload) throws IOException {
        try {
            Map response = StreamingIngestUtils.executeWithRetries(Map.class, "/v1/streaming/client/configure/", mapper.writeValueAsString(payload), "client configure", ServiceResponseHandler.ApiName.STREAMING_CLIENT_CONFIGURE, this.httpClient, this.requestBuilder, statusGetter);
            if (!response.get("status_code").equals(0)) {
                throw new SFException(ErrorCode.CLIENT_CONFIGURE_FAILURE, response.get("message").toString());
            }
            return response;
        }
        catch (IngestResponseException e) {
            throw new SFException(e, ErrorCode.CLIENT_CONFIGURE_FAILURE, e.getMessage());
        }
    }

    void put(String filePath, byte[] blob) {
        if (this.isLocalFS()) {
            this.putLocal(filePath, blob);
        } else {
            try {
                this.putRemote(filePath, blob);
            }
            catch (IOException | SnowflakeSQLException e) {
                throw new SFException(e, ErrorCode.BLOB_UPLOAD_FAILURE, new Object[0]);
            }
        }
    }

    boolean isLocalFS() {
        return this.fileTransferMetadataWithAge.isLocalFS;
    }

    @VisibleForTesting
    void putLocal(String fullFilePath, byte[] data) {
        if (fullFilePath == null || fullFilePath.isEmpty() || fullFilePath.endsWith("/")) {
            throw new SFException(ErrorCode.BLOB_UPLOAD_FAILURE, new Object[0]);
        }
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        try {
            String stageLocation = this.fileTransferMetadataWithAge.localLocation;
            File destFile = Paths.get(stageLocation, fullFilePath).toFile();
            FileUtils.copyInputStreamToFile((InputStream)input, (File)destFile);
        }
        catch (Exception ex) {
            throw new SFException(ex, ErrorCode.BLOB_UPLOAD_FAILURE, new Object[0]);
        }
    }

    String getClientPrefix() {
        return this.clientPrefix;
    }

    private static class MapStatusGetter<T>
    implements Function<T, Long> {
        @Override
        public Long apply(T input) {
            try {
                return ((Integer)((Map)input).get("status_code")).longValue();
            }
            catch (Exception e) {
                throw new SFException(ErrorCode.INTERNAL_ERROR, "failed to get status_code from response");
            }
        }
    }

    static class SnowflakeFileTransferMetadataWithAge {
        SnowflakeFileTransferMetadataV1 fileTransferMetadata;
        private final boolean isLocalFS;
        private final String localLocation;
        Optional<Long> timestamp;

        SnowflakeFileTransferMetadataWithAge(SnowflakeFileTransferMetadataV1 fileTransferMetadata, Optional<Long> timestamp) {
            this.isLocalFS = false;
            this.fileTransferMetadata = fileTransferMetadata;
            this.timestamp = timestamp;
            this.localLocation = null;
        }

        SnowflakeFileTransferMetadataWithAge(String localLocation, Optional<Long> timestamp) {
            this.isLocalFS = true;
            this.localLocation = localLocation;
            this.timestamp = timestamp;
        }
    }
}

