/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.connection;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import net.snowflake.ingest.connection.TelemetryService;
import net.snowflake.ingest.utils.ThreadFactoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SecurityManager
implements AutoCloseable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SecurityManager.class);
    protected final String account;
    protected String publicKeyFingerPrint;
    protected final String user;
    protected final AtomicBoolean refreshFailed;
    final ThreadFactory tf = ThreadFactoryUtil.poolThreadFactory(this.getClass().getSimpleName(), true);
    protected ScheduledExecutorService tokenRefresher = Executors.newScheduledThreadPool(1, this.tf);
    protected final TelemetryService telemetryService;

    SecurityManager(String accountName, String username, TelemetryService telemetryService) {
        if (accountName == null || username == null) {
            throw new IllegalArgumentException();
        }
        this.account = this.parseAccount(accountName);
        this.user = username.toUpperCase();
        this.refreshFailed = new AtomicBoolean();
        this.telemetryService = telemetryService;
    }

    void setRefreshFailed(Boolean refreshFailed) {
        this.refreshFailed.set(refreshFailed);
    }

    private String parseAccount(String accountName) {
        String parseAccount = null;
        if (accountName.contains(".")) {
            String[] accountParts = accountName.split("[.]");
            if (accountParts.length > 1) {
                parseAccount = accountParts[0];
            }
        } else {
            parseAccount = accountName;
        }
        return parseAccount.toUpperCase();
    }

    abstract String getToken();

    abstract String getTokenType();

    abstract void refreshToken();

    @Override
    public abstract void close();
}

