/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.connection;

import java.io.IOException;
import java.util.UUID;
import net.snowflake.client.jdbc.internal.apache.http.HttpEntity;
import net.snowflake.client.jdbc.internal.apache.http.HttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.StatusLine;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpGet;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPost;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpUriRequest;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.client.jdbc.internal.apache.http.util.EntityUtils;
import net.snowflake.ingest.connection.HistoryRangeResponse;
import net.snowflake.ingest.connection.HistoryResponse;
import net.snowflake.ingest.connection.IngestResponse;
import net.snowflake.ingest.connection.IngestResponseException;
import net.snowflake.ingest.connection.RequestBuilder;
import net.snowflake.ingest.internal.fasterxml.jackson.databind.DeserializationFeature;
import net.snowflake.ingest.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.ingest.utils.BackOffException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceResponseHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceResponseHandler.class);
    static ObjectMapper mapper = new ObjectMapper();

    private static boolean isStatusOK(StatusLine statusLine) {
        return statusLine.getStatusCode() >= 200 && statusLine.getStatusCode() < 300;
    }

    public static IngestResponse unmarshallIngestResponse(HttpResponse response, UUID requestId, CloseableHttpClient httpClient, HttpPost httpPostForIngestFile, RequestBuilder builder) throws IOException, IngestResponseException, BackOffException {
        if (response == null) {
            LOGGER.warn("Null argument passed to unmarshallIngestResponse");
            throw new IllegalArgumentException();
        }
        response = ServiceResponseHandler.handleExceptionalStatus(response, requestId, ApiName.INSERT_FILES, httpClient, (HttpUriRequest)httpPostForIngestFile, builder);
        String blob = ServiceResponseHandler.consumeAndReturnResponseEntityAsString(response.getEntity());
        return mapper.readValue(blob, IngestResponse.class);
    }

    public static HistoryResponse unmarshallHistoryResponse(HttpResponse response, UUID requestId, CloseableHttpClient httpClient, HttpGet httpGetHistory, RequestBuilder builder) throws IOException, IngestResponseException, BackOffException {
        if (response == null) {
            LOGGER.warn("Null response passed to unmarshallHistoryResponse");
            throw new IllegalArgumentException();
        }
        response = ServiceResponseHandler.handleExceptionalStatus(response, requestId, ApiName.INSERT_REPORT, httpClient, (HttpUriRequest)httpGetHistory, builder);
        String blob = ServiceResponseHandler.consumeAndReturnResponseEntityAsString(response.getEntity());
        return mapper.readValue(blob, HistoryResponse.class);
    }

    public static HistoryRangeResponse unmarshallHistoryRangeResponse(HttpResponse response, UUID requestId, CloseableHttpClient httpClient, HttpGet request, RequestBuilder builder) throws IOException, IngestResponseException, BackOffException {
        if (response == null) {
            LOGGER.warn("Null response passed to unmarshallHistoryRangeResponse");
            throw new IllegalArgumentException();
        }
        response = ServiceResponseHandler.handleExceptionalStatus(response, requestId, ApiName.LOAD_HISTORY_SCAN, httpClient, (HttpUriRequest)request, builder);
        String blob = ServiceResponseHandler.consumeAndReturnResponseEntityAsString(response.getEntity());
        return mapper.readValue(blob, HistoryRangeResponse.class);
    }

    public static <T> T unmarshallStreamingIngestResponse(HttpResponse response, Class<T> valueType, ApiName apiName, CloseableHttpClient httpClient, HttpUriRequest request, RequestBuilder requestBuilder) throws IOException, IngestResponseException {
        if (response == null) {
            LOGGER.warn("Null response passed to {}", (Object)valueType.getName());
            throw new IllegalArgumentException();
        }
        response = ServiceResponseHandler.handleExceptionalStatus(response, null, apiName, httpClient, request, requestBuilder);
        String blob = ServiceResponseHandler.consumeAndReturnResponseEntityAsString(response.getEntity());
        return mapper.readValue(blob, valueType);
    }

    private static HttpResponse handleExceptionalStatus(HttpResponse response, UUID requestId, ApiName apiName, CloseableHttpClient httpClient, HttpUriRequest request, RequestBuilder requestBuilder) throws IOException, IngestResponseException, BackOffException {
        if (!ServiceResponseHandler.isStatusOK(response.getStatusLine())) {
            StatusLine statusLine = response.getStatusLine();
            LOGGER.warn("{} Status hit from {}, requestId:{}", new Object[]{statusLine.getStatusCode(), apiName, requestId == null ? "" : requestId.toString()});
            String blob = ServiceResponseHandler.consumeAndReturnResponseEntityAsString(response.getEntity());
            switch (statusLine.getStatusCode()) {
                case 503: {
                    throw new BackOffException();
                }
                case 401: {
                    LOGGER.warn("Authorization failed, refreshing Token succeeded, retry");
                    requestBuilder.refreshToken();
                    requestBuilder.addToken(request);
                    response = httpClient.execute(request);
                    if (ServiceResponseHandler.isStatusOK(response.getStatusLine())) break;
                    ServiceResponseHandler.consumeAndReturnResponseEntityAsString(response.getEntity());
                    throw new SecurityException("Authorization failed after retry");
                }
                default: {
                    throw new IngestResponseException(statusLine.getStatusCode(), IngestResponseException.IngestExceptionBody.parseBody(blob));
                }
            }
        }
        return response;
    }

    private static String consumeAndReturnResponseEntityAsString(HttpEntity httpResponseEntity) throws IOException {
        String responseEntityAsString = EntityUtils.toString((HttpEntity)httpResponseEntity);
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return responseEntityAsString;
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static enum ApiName {
        INSERT_FILES("POST"),
        INSERT_REPORT("GET"),
        LOAD_HISTORY_SCAN("GET"),
        STREAMING_OPEN_CHANNEL("POST"),
        STREAMING_DROP_CHANNEL("POST"),
        STREAMING_CHANNEL_STATUS("POST"),
        STREAMING_REGISTER_BLOB("POST"),
        STREAMING_CLIENT_CONFIGURE("POST"),
        STREAMING_CHANNEL_CONFIGURE("POST");

        private final String httpMethod;

        private ApiName(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public String getHttpMethod() {
            return this.httpMethod;
        }
    }
}

