/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.commons.math3.linear;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Arrays;
import net.snowflake.ingest.internal.apache.commons.math3.Field;
import net.snowflake.ingest.internal.apache.commons.math3.FieldElement;
import net.snowflake.ingest.internal.apache.commons.math3.exception.DimensionMismatchException;
import net.snowflake.ingest.internal.apache.commons.math3.exception.MathArithmeticException;
import net.snowflake.ingest.internal.apache.commons.math3.exception.NoDataException;
import net.snowflake.ingest.internal.apache.commons.math3.exception.NullArgumentException;
import net.snowflake.ingest.internal.apache.commons.math3.exception.NumberIsTooSmallException;
import net.snowflake.ingest.internal.apache.commons.math3.exception.OutOfRangeException;
import net.snowflake.ingest.internal.apache.commons.math3.exception.ZeroException;
import net.snowflake.ingest.internal.apache.commons.math3.exception.util.Localizable;
import net.snowflake.ingest.internal.apache.commons.math3.exception.util.LocalizedFormats;
import net.snowflake.ingest.internal.apache.commons.math3.fraction.BigFraction;
import net.snowflake.ingest.internal.apache.commons.math3.fraction.Fraction;
import net.snowflake.ingest.internal.apache.commons.math3.linear.AnyMatrix;
import net.snowflake.ingest.internal.apache.commons.math3.linear.Array2DRowFieldMatrix;
import net.snowflake.ingest.internal.apache.commons.math3.linear.Array2DRowRealMatrix;
import net.snowflake.ingest.internal.apache.commons.math3.linear.ArrayFieldVector;
import net.snowflake.ingest.internal.apache.commons.math3.linear.ArrayRealVector;
import net.snowflake.ingest.internal.apache.commons.math3.linear.BlockFieldMatrix;
import net.snowflake.ingest.internal.apache.commons.math3.linear.BlockRealMatrix;
import net.snowflake.ingest.internal.apache.commons.math3.linear.DefaultFieldMatrixPreservingVisitor;
import net.snowflake.ingest.internal.apache.commons.math3.linear.FieldMatrix;
import net.snowflake.ingest.internal.apache.commons.math3.linear.FieldVector;
import net.snowflake.ingest.internal.apache.commons.math3.linear.MatrixDimensionMismatchException;
import net.snowflake.ingest.internal.apache.commons.math3.linear.NonSquareMatrixException;
import net.snowflake.ingest.internal.apache.commons.math3.linear.NonSymmetricMatrixException;
import net.snowflake.ingest.internal.apache.commons.math3.linear.RealMatrix;
import net.snowflake.ingest.internal.apache.commons.math3.linear.RealMatrixFormat;
import net.snowflake.ingest.internal.apache.commons.math3.linear.RealVector;
import net.snowflake.ingest.internal.apache.commons.math3.linear.SingularValueDecomposition;
import net.snowflake.ingest.internal.apache.commons.math3.util.FastMath;
import net.snowflake.ingest.internal.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixUtils {
    public static final RealMatrixFormat DEFAULT_FORMAT = RealMatrixFormat.getInstance();
    public static final RealMatrixFormat OCTAVE_FORMAT = new RealMatrixFormat("[", "]", "", "", "; ", ", ");

    private MatrixUtils() {
    }

    public static RealMatrix createRealMatrix(int rows, int columns) {
        return rows * columns <= 4096 ? new Array2DRowRealMatrix(rows, columns) : new BlockRealMatrix(rows, columns);
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createFieldMatrix(Field<T> field, int rows, int columns) {
        return rows * columns <= 4096 ? new Array2DRowFieldMatrix<T>(field, rows, columns) : new BlockFieldMatrix<T>(field, rows, columns);
    }

    public static RealMatrix createRealMatrix(double[][] data) throws NullArgumentException, DimensionMismatchException, NoDataException {
        if (data == null || data[0] == null) {
            throw new NullArgumentException();
        }
        return data.length * data[0].length <= 4096 ? new Array2DRowRealMatrix(data) : new BlockRealMatrix(data);
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createFieldMatrix(T[][] data) throws DimensionMismatchException, NoDataException, NullArgumentException {
        if (data == null || data[0] == null) {
            throw new NullArgumentException();
        }
        return data.length * data[0].length <= 4096 ? new Array2DRowFieldMatrix(data) : new BlockFieldMatrix(data);
    }

    public static RealMatrix createRealIdentityMatrix(int dimension) {
        RealMatrix m4 = MatrixUtils.createRealMatrix(dimension, dimension);
        for (int i = 0; i < dimension; ++i) {
            m4.setEntry(i, i, 1.0);
        }
        return m4;
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createFieldIdentityMatrix(Field<T> field, int dimension) {
        FieldElement zero = (FieldElement)field.getZero();
        FieldElement one = (FieldElement)field.getOne();
        FieldElement[][] d = (FieldElement[][])Array.newInstance(field.getRuntimeClass(), dimension, dimension);
        for (int row = 0; row < dimension; ++row) {
            Object[] dRow = d[row];
            Arrays.fill(dRow, zero);
            dRow[row] = one;
        }
        return new Array2DRowFieldMatrix(field, d, false);
    }

    public static RealMatrix createRealDiagonalMatrix(double[] diagonal) {
        RealMatrix m4 = MatrixUtils.createRealMatrix(diagonal.length, diagonal.length);
        for (int i = 0; i < diagonal.length; ++i) {
            m4.setEntry(i, i, diagonal[i]);
        }
        return m4;
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createFieldDiagonalMatrix(T[] diagonal) {
        FieldMatrix<T> m4 = MatrixUtils.createFieldMatrix(diagonal[0].getField(), diagonal.length, diagonal.length);
        for (int i = 0; i < diagonal.length; ++i) {
            m4.setEntry(i, i, diagonal[i]);
        }
        return m4;
    }

    public static RealVector createRealVector(double[] data) throws NoDataException, NullArgumentException {
        if (data == null) {
            throw new NullArgumentException();
        }
        return new ArrayRealVector(data, true);
    }

    public static <T extends FieldElement<T>> FieldVector<T> createFieldVector(T[] data) throws NoDataException, NullArgumentException, ZeroException {
        if (data == null) {
            throw new NullArgumentException();
        }
        if (data.length == 0) {
            throw new ZeroException((Localizable)LocalizedFormats.VECTOR_MUST_HAVE_AT_LEAST_ONE_ELEMENT, new Object[0]);
        }
        return new ArrayFieldVector(data[0].getField(), data, true);
    }

    public static RealMatrix createRowRealMatrix(double[] rowData) throws NoDataException, NullArgumentException {
        if (rowData == null) {
            throw new NullArgumentException();
        }
        int nCols = rowData.length;
        RealMatrix m4 = MatrixUtils.createRealMatrix(1, nCols);
        for (int i = 0; i < nCols; ++i) {
            m4.setEntry(0, i, rowData[i]);
        }
        return m4;
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createRowFieldMatrix(T[] rowData) throws NoDataException, NullArgumentException {
        if (rowData == null) {
            throw new NullArgumentException();
        }
        int nCols = rowData.length;
        if (nCols == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
        }
        FieldMatrix<T> m4 = MatrixUtils.createFieldMatrix(rowData[0].getField(), 1, nCols);
        for (int i = 0; i < nCols; ++i) {
            m4.setEntry(0, i, rowData[i]);
        }
        return m4;
    }

    public static RealMatrix createColumnRealMatrix(double[] columnData) throws NoDataException, NullArgumentException {
        if (columnData == null) {
            throw new NullArgumentException();
        }
        int nRows = columnData.length;
        RealMatrix m4 = MatrixUtils.createRealMatrix(nRows, 1);
        for (int i = 0; i < nRows; ++i) {
            m4.setEntry(i, 0, columnData[i]);
        }
        return m4;
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createColumnFieldMatrix(T[] columnData) throws NoDataException, NullArgumentException {
        if (columnData == null) {
            throw new NullArgumentException();
        }
        int nRows = columnData.length;
        if (nRows == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
        }
        FieldMatrix<T> m4 = MatrixUtils.createFieldMatrix(columnData[0].getField(), nRows, 1);
        for (int i = 0; i < nRows; ++i) {
            m4.setEntry(i, 0, columnData[i]);
        }
        return m4;
    }

    private static boolean isSymmetricInternal(RealMatrix matrix, double relativeTolerance, boolean raiseException) {
        int rows = matrix.getRowDimension();
        if (rows != matrix.getColumnDimension()) {
            if (raiseException) {
                throw new NonSquareMatrixException(rows, matrix.getColumnDimension());
            }
            return false;
        }
        for (int i = 0; i < rows; ++i) {
            for (int j = i + 1; j < rows; ++j) {
                double mji;
                double mij = matrix.getEntry(i, j);
                if (!(FastMath.abs(mij - (mji = matrix.getEntry(j, i))) > FastMath.max(FastMath.abs(mij), FastMath.abs(mji)) * relativeTolerance)) continue;
                if (raiseException) {
                    throw new NonSymmetricMatrixException(i, j, relativeTolerance);
                }
                return false;
            }
        }
        return true;
    }

    public static void checkSymmetric(RealMatrix matrix, double eps) {
        MatrixUtils.isSymmetricInternal(matrix, eps, true);
    }

    public static boolean isSymmetric(RealMatrix matrix, double eps) {
        return MatrixUtils.isSymmetricInternal(matrix, eps, false);
    }

    public static void checkMatrixIndex(AnyMatrix m4, int row, int column) throws OutOfRangeException {
        MatrixUtils.checkRowIndex(m4, row);
        MatrixUtils.checkColumnIndex(m4, column);
    }

    public static void checkRowIndex(AnyMatrix m4, int row) throws OutOfRangeException {
        if (row < 0 || row >= m4.getRowDimension()) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.ROW_INDEX, (Number)row, 0, m4.getRowDimension() - 1);
        }
    }

    public static void checkColumnIndex(AnyMatrix m4, int column) throws OutOfRangeException {
        if (column < 0 || column >= m4.getColumnDimension()) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.COLUMN_INDEX, (Number)column, 0, m4.getColumnDimension() - 1);
        }
    }

    public static void checkSubMatrixIndex(AnyMatrix m4, int startRow, int endRow, int startColumn, int endColumn) throws NumberIsTooSmallException, OutOfRangeException {
        MatrixUtils.checkRowIndex(m4, startRow);
        MatrixUtils.checkRowIndex(m4, endRow);
        if (endRow < startRow) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INITIAL_ROW_AFTER_FINAL_ROW, (Number)endRow, startRow, false);
        }
        MatrixUtils.checkColumnIndex(m4, startColumn);
        MatrixUtils.checkColumnIndex(m4, endColumn);
        if (endColumn < startColumn) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INITIAL_COLUMN_AFTER_FINAL_COLUMN, (Number)endColumn, startColumn, false);
        }
    }

    public static void checkSubMatrixIndex(AnyMatrix m4, int[] selectedRows, int[] selectedColumns) throws NoDataException, NullArgumentException, OutOfRangeException {
        if (selectedRows == null) {
            throw new NullArgumentException();
        }
        if (selectedColumns == null) {
            throw new NullArgumentException();
        }
        if (selectedRows.length == 0) {
            throw new NoDataException(LocalizedFormats.EMPTY_SELECTED_ROW_INDEX_ARRAY);
        }
        if (selectedColumns.length == 0) {
            throw new NoDataException(LocalizedFormats.EMPTY_SELECTED_COLUMN_INDEX_ARRAY);
        }
        for (int row : selectedRows) {
            MatrixUtils.checkRowIndex(m4, row);
        }
        for (int column : selectedColumns) {
            MatrixUtils.checkColumnIndex(m4, column);
        }
    }

    public static void checkAdditionCompatible(AnyMatrix left, AnyMatrix right) throws MatrixDimensionMismatchException {
        if (left.getRowDimension() != right.getRowDimension() || left.getColumnDimension() != right.getColumnDimension()) {
            throw new MatrixDimensionMismatchException(left.getRowDimension(), left.getColumnDimension(), right.getRowDimension(), right.getColumnDimension());
        }
    }

    public static void checkSubtractionCompatible(AnyMatrix left, AnyMatrix right) throws MatrixDimensionMismatchException {
        if (left.getRowDimension() != right.getRowDimension() || left.getColumnDimension() != right.getColumnDimension()) {
            throw new MatrixDimensionMismatchException(left.getRowDimension(), left.getColumnDimension(), right.getRowDimension(), right.getColumnDimension());
        }
    }

    public static void checkMultiplicationCompatible(AnyMatrix left, AnyMatrix right) throws DimensionMismatchException {
        if (left.getColumnDimension() != right.getRowDimension()) {
            throw new DimensionMismatchException(left.getColumnDimension(), right.getRowDimension());
        }
    }

    public static Array2DRowRealMatrix fractionMatrixToRealMatrix(FieldMatrix<Fraction> m4) {
        FractionMatrixConverter converter = new FractionMatrixConverter();
        m4.walkInOptimizedOrder(converter);
        return converter.getConvertedMatrix();
    }

    public static Array2DRowRealMatrix bigFractionMatrixToRealMatrix(FieldMatrix<BigFraction> m4) {
        BigFractionMatrixConverter converter = new BigFractionMatrixConverter();
        m4.walkInOptimizedOrder(converter);
        return converter.getConvertedMatrix();
    }

    public static void serializeRealVector(RealVector vector, ObjectOutputStream oos) throws IOException {
        int n = vector.getDimension();
        oos.writeInt(n);
        for (int i = 0; i < n; ++i) {
            oos.writeDouble(vector.getEntry(i));
        }
    }

    public static void deserializeRealVector(Object instance, String fieldName, ObjectInputStream ois) throws ClassNotFoundException, IOException {
        try {
            int n = ois.readInt();
            double[] data = new double[n];
            for (int i = 0; i < n; ++i) {
                data[i] = ois.readDouble();
            }
            ArrayRealVector vector = new ArrayRealVector(data, false);
            java.lang.reflect.Field f = instance.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            f.set(instance, vector);
        }
        catch (NoSuchFieldException nsfe) {
            IOException ioe = new IOException();
            ioe.initCause(nsfe);
            throw ioe;
        }
        catch (IllegalAccessException iae) {
            IOException ioe = new IOException();
            ioe.initCause(iae);
            throw ioe;
        }
    }

    public static void serializeRealMatrix(RealMatrix matrix, ObjectOutputStream oos) throws IOException {
        int n = matrix.getRowDimension();
        int m4 = matrix.getColumnDimension();
        oos.writeInt(n);
        oos.writeInt(m4);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m4; ++j) {
                oos.writeDouble(matrix.getEntry(i, j));
            }
        }
    }

    public static void deserializeRealMatrix(Object instance, String fieldName, ObjectInputStream ois) throws ClassNotFoundException, IOException {
        try {
            int n = ois.readInt();
            int m4 = ois.readInt();
            double[][] data = new double[n][m4];
            for (int i = 0; i < n; ++i) {
                double[] dataI = data[i];
                for (int j = 0; j < m4; ++j) {
                    dataI[j] = ois.readDouble();
                }
            }
            Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(data, false);
            java.lang.reflect.Field f = instance.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            f.set(instance, matrix);
        }
        catch (NoSuchFieldException nsfe) {
            IOException ioe = new IOException();
            ioe.initCause(nsfe);
            throw ioe;
        }
        catch (IllegalAccessException iae) {
            IOException ioe = new IOException();
            ioe.initCause(iae);
            throw ioe;
        }
    }

    public static void solveLowerTriangularSystem(RealMatrix rm, RealVector b) throws DimensionMismatchException, MathArithmeticException, NonSquareMatrixException {
        if (rm == null || b == null || rm.getRowDimension() != b.getDimension()) {
            throw new DimensionMismatchException(rm == null ? 0 : rm.getRowDimension(), b == null ? 0 : b.getDimension());
        }
        if (rm.getColumnDimension() != rm.getRowDimension()) {
            throw new NonSquareMatrixException(rm.getRowDimension(), rm.getColumnDimension());
        }
        int rows = rm.getRowDimension();
        for (int i = 0; i < rows; ++i) {
            double diag = rm.getEntry(i, i);
            if (FastMath.abs(diag) < Precision.SAFE_MIN) {
                throw new MathArithmeticException(LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
            }
            double bi = b.getEntry(i) / diag;
            b.setEntry(i, bi);
            for (int j = i + 1; j < rows; ++j) {
                b.setEntry(j, b.getEntry(j) - bi * rm.getEntry(j, i));
            }
        }
    }

    public static void solveUpperTriangularSystem(RealMatrix rm, RealVector b) throws DimensionMismatchException, MathArithmeticException, NonSquareMatrixException {
        if (rm == null || b == null || rm.getRowDimension() != b.getDimension()) {
            throw new DimensionMismatchException(rm == null ? 0 : rm.getRowDimension(), b == null ? 0 : b.getDimension());
        }
        if (rm.getColumnDimension() != rm.getRowDimension()) {
            throw new NonSquareMatrixException(rm.getRowDimension(), rm.getColumnDimension());
        }
        int rows = rm.getRowDimension();
        for (int i = rows - 1; i > -1; --i) {
            double diag = rm.getEntry(i, i);
            if (FastMath.abs(diag) < Precision.SAFE_MIN) {
                throw new MathArithmeticException(LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
            }
            double bi = b.getEntry(i) / diag;
            b.setEntry(i, bi);
            for (int j = i - 1; j > -1; --j) {
                b.setEntry(j, b.getEntry(j) - bi * rm.getEntry(j, i));
            }
        }
    }

    public static RealMatrix blockInverse(RealMatrix m4, int splitIndex) {
        int n = m4.getRowDimension();
        if (m4.getColumnDimension() != n) {
            throw new NonSquareMatrixException(m4.getRowDimension(), m4.getColumnDimension());
        }
        int splitIndex1 = splitIndex + 1;
        RealMatrix a = m4.getSubMatrix(0, splitIndex, 0, splitIndex);
        RealMatrix b = m4.getSubMatrix(0, splitIndex, splitIndex1, n - 1);
        RealMatrix c = m4.getSubMatrix(splitIndex1, n - 1, 0, splitIndex);
        RealMatrix d = m4.getSubMatrix(splitIndex1, n - 1, splitIndex1, n - 1);
        SingularValueDecomposition aDec = new SingularValueDecomposition(a);
        RealMatrix aInv = aDec.getSolver().getInverse();
        SingularValueDecomposition dDec = new SingularValueDecomposition(d);
        RealMatrix dInv = dDec.getSolver().getInverse();
        RealMatrix tmp1 = a.subtract(b.multiply(dInv).multiply(c));
        SingularValueDecomposition tmp1Dec = new SingularValueDecomposition(tmp1);
        RealMatrix result00 = tmp1Dec.getSolver().getInverse();
        RealMatrix tmp2 = d.subtract(c.multiply(aInv).multiply(b));
        SingularValueDecomposition tmp2Dec = new SingularValueDecomposition(tmp2);
        RealMatrix result11 = tmp2Dec.getSolver().getInverse();
        RealMatrix result01 = aInv.multiply(b).multiply(result11).scalarMultiply(-1.0);
        RealMatrix result10 = dInv.multiply(c).multiply(result00).scalarMultiply(-1.0);
        Array2DRowRealMatrix result = new Array2DRowRealMatrix(n, n);
        result.setSubMatrix(result00.getData(), 0, 0);
        result.setSubMatrix(result01.getData(), 0, splitIndex1);
        result.setSubMatrix(result10.getData(), splitIndex1, 0);
        result.setSubMatrix(result11.getData(), splitIndex1, splitIndex1);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BigFractionMatrixConverter
    extends DefaultFieldMatrixPreservingVisitor<BigFraction> {
        private double[][] data;

        public BigFractionMatrixConverter() {
            super(BigFraction.ZERO);
        }

        @Override
        public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
            this.data = new double[rows][columns];
        }

        @Override
        public void visit(int row, int column, BigFraction value) {
            this.data[row][column] = value.doubleValue();
        }

        Array2DRowRealMatrix getConvertedMatrix() {
            return new Array2DRowRealMatrix(this.data, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FractionMatrixConverter
    extends DefaultFieldMatrixPreservingVisitor<Fraction> {
        private double[][] data;

        public FractionMatrixConverter() {
            super(Fraction.ZERO);
        }

        @Override
        public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
            this.data = new double[rows][columns];
        }

        @Override
        public void visit(int row, int column, Fraction value) {
            this.data[row][column] = value.doubleValue();
        }

        Array2DRowRealMatrix getConvertedMatrix() {
            return new Array2DRowRealMatrix(this.data, false);
        }
    }
}

