/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.fs.BlockLocation;
import net.snowflake.ingest.internal.apache.hadoop.fs.BlockStoragePolicySpi;
import net.snowflake.ingest.internal.apache.hadoop.fs.CreateFlag;
import net.snowflake.ingest.internal.apache.hadoop.fs.FSDataInputStream;
import net.snowflake.ingest.internal.apache.hadoop.fs.FSDataOutputStream;
import net.snowflake.ingest.internal.apache.hadoop.fs.FSDataOutputStreamBuilder;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileAlreadyExistsException;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileChecksum;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileStatus;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileSystem;
import net.snowflake.ingest.internal.apache.hadoop.fs.FsServerDefaults;
import net.snowflake.ingest.internal.apache.hadoop.fs.FsStatus;
import net.snowflake.ingest.internal.apache.hadoop.fs.FutureDataInputStreamBuilder;
import net.snowflake.ingest.internal.apache.hadoop.fs.LocatedFileStatus;
import net.snowflake.ingest.internal.apache.hadoop.fs.Options;
import net.snowflake.ingest.internal.apache.hadoop.fs.ParentNotDirectoryException;
import net.snowflake.ingest.internal.apache.hadoop.fs.Path;
import net.snowflake.ingest.internal.apache.hadoop.fs.PathFilter;
import net.snowflake.ingest.internal.apache.hadoop.fs.PathHandle;
import net.snowflake.ingest.internal.apache.hadoop.fs.RemoteIterator;
import net.snowflake.ingest.internal.apache.hadoop.fs.UnsupportedFileSystemException;
import net.snowflake.ingest.internal.apache.hadoop.fs.XAttrSetFlag;
import net.snowflake.ingest.internal.apache.hadoop.fs.impl.OpenFileParameters;
import net.snowflake.ingest.internal.apache.hadoop.fs.impl.PathCapabilitiesSupport;
import net.snowflake.ingest.internal.apache.hadoop.fs.permission.AclEntry;
import net.snowflake.ingest.internal.apache.hadoop.fs.permission.AclStatus;
import net.snowflake.ingest.internal.apache.hadoop.fs.permission.FsAction;
import net.snowflake.ingest.internal.apache.hadoop.fs.permission.FsPermission;
import net.snowflake.ingest.internal.apache.hadoop.security.AccessControlException;
import net.snowflake.ingest.internal.apache.hadoop.util.Progressable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FilterFileSystem
extends FileSystem {
    protected FileSystem fs;
    protected String swapScheme;

    public FilterFileSystem() {
    }

    public FilterFileSystem(FileSystem fs) {
        this.fs = fs;
        this.statistics = fs.statistics;
    }

    public FileSystem getRawFileSystem() {
        return this.fs;
    }

    @Override
    public void initialize(URI name, Configuration conf) throws IOException {
        String scheme;
        super.initialize(name, conf);
        if (this.fs.getConf() == null) {
            this.fs.initialize(name, conf);
        }
        if (!(scheme = name.getScheme()).equals(this.fs.getUri().getScheme())) {
            this.swapScheme = scheme;
        }
    }

    @Override
    public URI getUri() {
        return this.fs.getUri();
    }

    @Override
    protected URI getCanonicalUri() {
        return this.fs.getCanonicalUri();
    }

    @Override
    protected URI canonicalizeUri(URI uri) {
        return this.fs.canonicalizeUri(uri);
    }

    @Override
    public Path makeQualified(Path path) {
        Path fqPath = this.fs.makeQualified(path);
        if (this.swapScheme != null) {
            try {
                fqPath = new Path(new URI(this.swapScheme, fqPath.toUri().getSchemeSpecificPart(), null));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return fqPath;
    }

    @Override
    protected void checkPath(Path path) {
        this.fs.checkPath(path);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        return this.fs.getFileBlockLocations(file, start, len);
    }

    @Override
    public Path resolvePath(Path p) throws IOException {
        return this.fs.resolvePath(p);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return this.fs.open(f, bufferSize);
    }

    @Override
    public FSDataInputStream open(PathHandle fd, int bufferSize) throws IOException {
        return this.fs.open(fd, bufferSize);
    }

    @Override
    protected PathHandle createPathHandle(FileStatus stat, Options.HandleOpt ... opts) {
        return this.fs.getPathHandle(stat, opts);
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        return this.fs.append(f, bufferSize, progress);
    }

    @Override
    public void concat(Path f, Path[] psrcs) throws IOException {
        this.fs.concat(f, psrcs);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.fs.create(f, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        return this.fs.create(f, permission, flags, bufferSize, replication, blockSize, progress, checksumOpt);
    }

    @Override
    protected RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f, PathFilter filter) throws FileNotFoundException, IOException {
        return this.fs.listLocatedStatus(f, filter);
    }

    @Override
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.fs.createNonRecursive(f, permission, flags, bufferSize, replication, blockSize, progress);
    }

    @Override
    public boolean setReplication(Path src, short replication) throws IOException {
        return this.fs.setReplication(src, replication);
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        return this.fs.rename(src, dst);
    }

    @Override
    protected void rename(Path src, Path dst, Options.Rename ... options) throws IOException {
        this.fs.rename(src, dst, options);
    }

    @Override
    public boolean truncate(Path f, long newLength) throws IOException {
        return this.fs.truncate(f, newLength);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.fs.delete(f, recursive);
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        return this.fs.listStatus(f);
    }

    @Override
    public RemoteIterator<Path> listCorruptFileBlocks(Path path) throws IOException {
        return this.fs.listCorruptFileBlocks(path);
    }

    @Override
    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws IOException {
        return this.fs.listLocatedStatus(f);
    }

    @Override
    public RemoteIterator<FileStatus> listStatusIterator(Path f) throws IOException {
        return this.fs.listStatusIterator(f);
    }

    @Override
    public Path getHomeDirectory() {
        return this.fs.getHomeDirectory();
    }

    @Override
    public void setWorkingDirectory(Path newDir) {
        this.fs.setWorkingDirectory(newDir);
    }

    @Override
    public Path getWorkingDirectory() {
        return this.fs.getWorkingDirectory();
    }

    @Override
    protected Path getInitialWorkingDirectory() {
        return this.fs.getInitialWorkingDirectory();
    }

    @Override
    public FsStatus getStatus(Path p) throws IOException {
        return this.fs.getStatus(p);
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.fs.mkdirs(f, permission);
    }

    @Override
    public boolean mkdirs(Path f) throws IOException {
        return this.fs.mkdirs(f);
    }

    @Override
    public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.fs.copyFromLocalFile(delSrc, src, dst);
    }

    @Override
    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path[] srcs, Path dst) throws IOException {
        this.fs.copyFromLocalFile(delSrc, overwrite, srcs, dst);
    }

    @Override
    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        this.fs.copyFromLocalFile(delSrc, overwrite, src, dst);
    }

    @Override
    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.fs.copyToLocalFile(delSrc, src, dst);
    }

    @Override
    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        return this.fs.startLocalOutput(fsOutputFile, tmpLocalFile);
    }

    @Override
    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        this.fs.completeLocalOutput(fsOutputFile, tmpLocalFile);
    }

    @Override
    public long getUsed() throws IOException {
        return this.fs.getUsed();
    }

    @Override
    public long getUsed(Path path) throws IOException {
        return this.fs.getUsed(path);
    }

    @Override
    public long getDefaultBlockSize() {
        return this.fs.getDefaultBlockSize();
    }

    @Override
    public short getDefaultReplication() {
        return this.fs.getDefaultReplication();
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        return this.fs.getServerDefaults();
    }

    @Override
    public long getDefaultBlockSize(Path f) {
        return this.fs.getDefaultBlockSize(f);
    }

    @Override
    public short getDefaultReplication(Path f) {
        return this.fs.getDefaultReplication(f);
    }

    @Override
    public FsServerDefaults getServerDefaults(Path f) throws IOException {
        return this.fs.getServerDefaults(f);
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        return this.fs.getFileStatus(f);
    }

    @Override
    public void msync() throws IOException, UnsupportedOperationException {
        this.fs.msync();
    }

    @Override
    public void access(Path path, FsAction mode) throws AccessControlException, FileNotFoundException, IOException {
        this.fs.access(path, mode);
    }

    @Override
    public void createSymlink(Path target, Path link, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException {
        this.fs.createSymlink(target, link, createParent);
    }

    @Override
    public FileStatus getFileLinkStatus(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        return this.fs.getFileLinkStatus(f);
    }

    @Override
    public boolean supportsSymlinks() {
        return this.fs.supportsSymlinks();
    }

    @Override
    public Path getLinkTarget(Path f) throws IOException {
        return this.fs.getLinkTarget(f);
    }

    @Override
    protected Path resolveLink(Path f) throws IOException {
        return this.fs.resolveLink(f);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws IOException {
        return this.fs.getFileChecksum(f);
    }

    @Override
    public FileChecksum getFileChecksum(Path f, long length) throws IOException {
        return this.fs.getFileChecksum(f, length);
    }

    @Override
    public void setVerifyChecksum(boolean verifyChecksum) {
        this.fs.setVerifyChecksum(verifyChecksum);
    }

    @Override
    public void setWriteChecksum(boolean writeChecksum) {
        this.fs.setWriteChecksum(writeChecksum);
    }

    @Override
    public Configuration getConf() {
        return this.fs.getConf();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.fs.close();
    }

    @Override
    public void setOwner(Path p, String username, String groupname) throws IOException {
        this.fs.setOwner(p, username, groupname);
    }

    @Override
    public void setTimes(Path p, long mtime, long atime) throws IOException {
        this.fs.setTimes(p, mtime, atime);
    }

    @Override
    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.fs.setPermission(p, permission);
    }

    @Override
    protected FSDataOutputStream primitiveCreate(Path f, FsPermission absolutePermission, EnumSet<CreateFlag> flag, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        return this.fs.primitiveCreate(f, absolutePermission, flag, bufferSize, replication, blockSize, progress, checksumOpt);
    }

    @Override
    protected boolean primitiveMkdir(Path f, FsPermission abdolutePermission) throws IOException {
        return this.fs.primitiveMkdir(f, abdolutePermission);
    }

    @Override
    public FileSystem[] getChildFileSystems() {
        return new FileSystem[]{this.fs};
    }

    @Override
    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        return this.fs.createSnapshot(path, snapshotName);
    }

    @Override
    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        this.fs.renameSnapshot(path, snapshotOldName, snapshotNewName);
    }

    @Override
    public void deleteSnapshot(Path path, String snapshotName) throws IOException {
        this.fs.deleteSnapshot(path, snapshotName);
    }

    @Override
    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.fs.modifyAclEntries(path, aclSpec);
    }

    @Override
    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.fs.removeAclEntries(path, aclSpec);
    }

    @Override
    public void removeDefaultAcl(Path path) throws IOException {
        this.fs.removeDefaultAcl(path);
    }

    @Override
    public void removeAcl(Path path) throws IOException {
        this.fs.removeAcl(path);
    }

    @Override
    public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
        this.fs.setAcl(path, aclSpec);
    }

    @Override
    public AclStatus getAclStatus(Path path) throws IOException {
        return this.fs.getAclStatus(path);
    }

    @Override
    public void setXAttr(Path path, String name, byte[] value) throws IOException {
        this.fs.setXAttr(path, name, value);
    }

    @Override
    public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        this.fs.setXAttr(path, name, value, flag);
    }

    @Override
    public byte[] getXAttr(Path path, String name) throws IOException {
        return this.fs.getXAttr(path, name);
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        return this.fs.getXAttrs(path);
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        return this.fs.getXAttrs(path, names);
    }

    @Override
    public List<String> listXAttrs(Path path) throws IOException {
        return this.fs.listXAttrs(path);
    }

    @Override
    public void removeXAttr(Path path, String name) throws IOException {
        this.fs.removeXAttr(path, name);
    }

    @Override
    public void satisfyStoragePolicy(Path src) throws IOException {
        this.fs.satisfyStoragePolicy(src);
    }

    @Override
    public void setStoragePolicy(Path src, String policyName) throws IOException {
        this.fs.setStoragePolicy(src, policyName);
    }

    @Override
    public void unsetStoragePolicy(Path src) throws IOException {
        this.fs.unsetStoragePolicy(src);
    }

    @Override
    public BlockStoragePolicySpi getStoragePolicy(Path src) throws IOException {
        return this.fs.getStoragePolicy(src);
    }

    @Override
    public Collection<? extends BlockStoragePolicySpi> getAllStoragePolicies() throws IOException {
        return this.fs.getAllStoragePolicies();
    }

    @Override
    public Path getTrashRoot(Path path) {
        return this.fs.getTrashRoot(path);
    }

    @Override
    public Collection<FileStatus> getTrashRoots(boolean allUsers) {
        return this.fs.getTrashRoots(allUsers);
    }

    @Override
    public FSDataOutputStreamBuilder createFile(Path path) {
        return this.fs.createFile(path);
    }

    @Override
    public FSDataOutputStreamBuilder appendFile(Path path) {
        return this.fs.appendFile(path);
    }

    @Override
    public FutureDataInputStreamBuilder openFile(Path path) throws IOException, UnsupportedOperationException {
        return this.fs.openFile(path);
    }

    @Override
    public FutureDataInputStreamBuilder openFile(PathHandle pathHandle) throws IOException, UnsupportedOperationException {
        return this.fs.openFile(pathHandle);
    }

    @Override
    protected CompletableFuture<FSDataInputStream> openFileWithOptions(Path path, OpenFileParameters parameters) throws IOException {
        return this.fs.openFileWithOptions(path, parameters);
    }

    @Override
    protected CompletableFuture<FSDataInputStream> openFileWithOptions(PathHandle pathHandle, OpenFileParameters parameters) throws IOException {
        return this.fs.openFileWithOptions(pathHandle, parameters);
    }

    @Override
    public boolean hasPathCapability(Path path, String capability) throws IOException {
        switch (PathCapabilitiesSupport.validatePathCapabilityArgs(this.makeQualified(path), capability)) {
            case "fs.capability.multipart.uploader": 
            case "fs.capability.batch.listing": {
                return false;
            }
        }
        return this.fs.hasPathCapability(path, capability);
    }
}

