/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs;

import java.io.IOException;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configured;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileSystem;
import net.snowflake.ingest.internal.apache.hadoop.fs.Path;
import net.snowflake.ingest.internal.apache.hadoop.fs.TrashPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Trash
extends Configured {
    private static final Logger LOG = LoggerFactory.getLogger(Trash.class);
    private TrashPolicy trashPolicy;

    public Trash(Configuration conf) throws IOException {
        this(FileSystem.get(conf), conf);
    }

    public Trash(FileSystem fs, Configuration conf) throws IOException {
        super(conf);
        this.trashPolicy = TrashPolicy.getInstance(conf, fs);
    }

    public static boolean moveToAppropriateTrash(FileSystem fs, Path p, Configuration conf) throws IOException {
        Path fullyResolvedPath = fs.resolvePath(p);
        FileSystem fullyResolvedFs = FileSystem.get(fullyResolvedPath.toUri(), conf);
        try {
            long trashInterval = fullyResolvedFs.getServerDefaults(fullyResolvedPath).getTrashInterval();
            if (0L != trashInterval) {
                Configuration confCopy = new Configuration(conf);
                confCopy.setLong("fs.trash.interval", trashInterval);
                conf = confCopy;
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to get server trash configuration", (Throwable)e);
            throw new IOException("Failed to get server trash configuration", e);
        }
        if (conf.getBoolean("fs.viewfs.trash.force-inside-mount-point", false)) {
            Trash trash = new Trash(fs, conf);
            return trash.moveToTrash(p);
        }
        Trash trash = new Trash(fullyResolvedFs, conf);
        return trash.moveToTrash(fullyResolvedPath);
    }

    public boolean isEnabled() {
        return this.trashPolicy.isEnabled();
    }

    public boolean moveToTrash(Path path) throws IOException {
        return this.trashPolicy.moveToTrash(path);
    }

    public void checkpoint() throws IOException {
        this.trashPolicy.createCheckpoint();
    }

    public void expunge() throws IOException {
        this.trashPolicy.deleteCheckpoint();
    }

    public void expungeImmediately() throws IOException {
        this.trashPolicy.createCheckpoint();
        this.trashPolicy.deleteCheckpointsImmediately();
    }

    Path getCurrentTrashDir() throws IOException {
        return this.trashPolicy.getCurrentTrashDir();
    }

    TrashPolicy getTrashPolicy() {
        return this.trashPolicy;
    }

    public Runnable getEmptier() throws IOException {
        return this.trashPolicy.getEmptier();
    }

    public Path getCurrentTrashDir(Path path) throws IOException {
        return this.trashPolicy.getCurrentTrashDir(path);
    }
}

