/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs.impl;

import java.io.IOException;
import java.util.EnumSet;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.fs.CreateFlag;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileContext;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileSystem;
import net.snowflake.ingest.internal.apache.hadoop.fs.FsServerDefaults;
import net.snowflake.ingest.internal.apache.hadoop.fs.MultipartUploader;
import net.snowflake.ingest.internal.apache.hadoop.fs.MultipartUploaderBuilder;
import net.snowflake.ingest.internal.apache.hadoop.fs.Options;
import net.snowflake.ingest.internal.apache.hadoop.fs.Path;
import net.snowflake.ingest.internal.apache.hadoop.fs.impl.AbstractFSBuilderImpl;
import net.snowflake.ingest.internal.apache.hadoop.fs.permission.FsPermission;
import net.snowflake.ingest.internal.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import net.snowflake.ingest.internal.javax.annotation.Nonnull;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class MultipartUploaderBuilderImpl<S extends MultipartUploader, B extends MultipartUploaderBuilder<S, B>>
extends AbstractFSBuilderImpl<S, B>
implements MultipartUploaderBuilder<S, B> {
    private final FileSystem fs;
    private FsPermission permission;
    private int bufferSize;
    private short replication;
    private long blockSize;
    private final EnumSet<CreateFlag> flags = EnumSet.noneOf(CreateFlag.class);
    private Options.ChecksumOpt checksumOpt;

    @Override
    public abstract B getThisBuilder();

    protected MultipartUploaderBuilderImpl(@Nonnull FileContext fc, @Nonnull Path p) throws IOException {
        super(Preconditions.checkNotNull(p));
        Preconditions.checkNotNull(fc);
        this.fs = null;
        FsServerDefaults defaults = fc.getServerDefaults(p);
        this.bufferSize = defaults.getFileBufferSize();
        this.replication = defaults.getReplication();
        this.blockSize = defaults.getBlockSize();
    }

    protected MultipartUploaderBuilderImpl(@Nonnull FileSystem fileSystem, @Nonnull Path p) {
        super(fileSystem.makeQualified(Preconditions.checkNotNull(p)));
        Preconditions.checkNotNull(fileSystem);
        this.fs = fileSystem;
        this.bufferSize = this.fs.getConf().getInt("io.file.buffer.size", 4096);
        this.replication = this.fs.getDefaultReplication(p);
        this.blockSize = this.fs.getDefaultBlockSize(p);
    }

    protected FileSystem getFS() {
        Preconditions.checkNotNull(this.fs);
        return this.fs;
    }

    protected FsPermission getPermission() {
        if (this.permission == null) {
            this.permission = FsPermission.getFileDefault();
        }
        return this.permission;
    }

    @Override
    public B permission(@Nonnull FsPermission perm) {
        Preconditions.checkNotNull(perm);
        this.permission = perm;
        return (B)this.getThisBuilder();
    }

    protected int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public B bufferSize(int bufSize) {
        this.bufferSize = bufSize;
        return (B)this.getThisBuilder();
    }

    protected short getReplication() {
        return this.replication;
    }

    @Override
    public B replication(short replica) {
        this.replication = replica;
        return (B)this.getThisBuilder();
    }

    protected long getBlockSize() {
        return this.blockSize;
    }

    @Override
    public B blockSize(long blkSize) {
        this.blockSize = blkSize;
        return (B)this.getThisBuilder();
    }

    protected EnumSet<CreateFlag> getFlags() {
        return this.flags;
    }

    @Override
    public B create() {
        this.flags.add(CreateFlag.CREATE);
        return (B)this.getThisBuilder();
    }

    @Override
    public B overwrite(boolean overwrite) {
        if (overwrite) {
            this.flags.add(CreateFlag.OVERWRITE);
        } else {
            this.flags.remove((Object)CreateFlag.OVERWRITE);
        }
        return (B)this.getThisBuilder();
    }

    @Override
    public B append() {
        this.flags.add(CreateFlag.APPEND);
        return (B)this.getThisBuilder();
    }

    protected Options.ChecksumOpt getChecksumOpt() {
        return this.checksumOpt;
    }

    @Override
    public B checksumOpt(@Nonnull Options.ChecksumOpt chksumOpt) {
        Preconditions.checkNotNull(chksumOpt);
        this.checksumOpt = chksumOpt;
        return (B)this.getThisBuilder();
    }
}

