/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs.impl.prefetch;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.snowflake.ingest.internal.apache.hadoop.fs.impl.prefetch.BlockData;
import net.snowflake.ingest.internal.apache.hadoop.fs.impl.prefetch.BufferData;
import net.snowflake.ingest.internal.apache.hadoop.fs.impl.prefetch.Validate;

public abstract class BlockManager
implements Closeable {
    private final BlockData blockData;

    public BlockManager(BlockData blockData) {
        Validate.checkNotNull(blockData, "blockData");
        this.blockData = blockData;
    }

    public BlockData getBlockData() {
        return this.blockData;
    }

    public BufferData get(int blockNumber) throws IOException {
        Validate.checkNotNegative(blockNumber, "blockNumber");
        int size = this.blockData.getSize(blockNumber);
        ByteBuffer buffer = ByteBuffer.allocate(size);
        long startOffset = this.blockData.getStartOffset(blockNumber);
        this.read(buffer, startOffset, size);
        buffer.flip();
        return new BufferData(blockNumber, buffer);
    }

    public abstract int read(ByteBuffer var1, long var2, int var4) throws IOException;

    public void release(BufferData data) {
        Validate.checkNotNull(data, "data");
    }

    public void requestPrefetch(int blockNumber) {
        Validate.checkNotNegative(blockNumber, "blockNumber");
    }

    public void cancelPrefetches() {
    }

    public void requestCaching(BufferData data) {
    }

    @Override
    public void close() {
    }
}

