/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs.impl.prefetch;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import net.snowflake.ingest.internal.apache.hadoop.fs.impl.prefetch.ResourcePool;
import net.snowflake.ingest.internal.apache.hadoop.fs.impl.prefetch.Validate;

public abstract class BoundedResourcePool<T>
extends ResourcePool<T> {
    private final int size;
    private ArrayBlockingQueue<T> items;
    private Set<T> createdItems;

    public BoundedResourcePool(int size) {
        Validate.checkPositiveInteger(size, "size");
        this.size = size;
        this.items = new ArrayBlockingQueue(size);
        this.createdItems = Collections.newSetFromMap(new IdentityHashMap());
    }

    @Override
    public T acquire() {
        return this.acquireHelper(true);
    }

    @Override
    public T tryAcquire() {
        return this.acquireHelper(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(T item) {
        Validate.checkNotNull(item, "item");
        Set<T> set = this.createdItems;
        synchronized (set) {
            if (!this.createdItems.contains(item)) {
                throw new IllegalArgumentException("This item is not a part of this pool");
            }
        }
        for (Object entry : this.items) {
            if (entry != item) continue;
            return;
        }
        try {
            this.items.put(item);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("release() should never block", e);
        }
    }

    @Override
    public synchronized void close() {
        for (T item : this.createdItems) {
            this.close(item);
        }
        this.items.clear();
        this.items = null;
        this.createdItems.clear();
        this.createdItems = null;
    }

    @Override
    protected synchronized void close(T item) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numCreated() {
        Set<T> set = this.createdItems;
        synchronized (set) {
            return this.createdItems.size();
        }
    }

    public synchronized int numAvailable() {
        return this.size - this.numCreated() + this.items.size();
    }

    public synchronized String toString() {
        return String.format("size = %d, #created = %d, #in-queue = %d, #available = %d", this.size, this.numCreated(), this.items.size(), this.numAvailable());
    }

    @Override
    protected abstract T createNew();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T acquireHelper(boolean canBlock) {
        T result = this.items.poll();
        if (result != null) {
            return result;
        }
        Set<T> set = this.createdItems;
        synchronized (set) {
            if (this.createdItems.size() < this.size) {
                T item = this.createNew();
                this.createdItems.add(item);
                return item;
            }
        }
        if (canBlock) {
            try {
                return this.items.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return null;
    }
}

