/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs.impl.prefetch;

import net.snowflake.ingest.internal.apache.hadoop.fs.impl.prefetch.Validate;

public class Retryer {
    private int maxDelay;
    private int perRetryDelay;
    private int statusUpdateInterval;
    private int delay;

    public Retryer(int perRetryDelay, int maxDelay, int statusUpdateInterval) {
        Validate.checkPositiveInteger(perRetryDelay, "perRetryDelay");
        Validate.checkGreater(maxDelay, "maxDelay", perRetryDelay, "perRetryDelay");
        Validate.checkPositiveInteger(statusUpdateInterval, "statusUpdateInterval");
        this.perRetryDelay = perRetryDelay;
        this.maxDelay = maxDelay;
        this.statusUpdateInterval = statusUpdateInterval;
    }

    public boolean continueRetry() {
        if (this.delay >= this.maxDelay) {
            return false;
        }
        try {
            Thread.sleep(this.perRetryDelay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.delay += this.perRetryDelay;
        return true;
    }

    public boolean updateStatus() {
        return this.delay > 0 && this.delay % this.statusUpdateInterval == 0;
    }
}

