/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs.permission;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class PermissionParser {
    protected boolean symbolic = false;
    protected short userMode;
    protected short groupMode;
    protected short othersMode;
    protected short stickyMode;
    protected char userType = (char)43;
    protected char groupType = (char)43;
    protected char othersType = (char)43;
    protected char stickyBitType = (char)43;

    public PermissionParser(String modeStr, Pattern symbolic, Pattern octal) throws IllegalArgumentException {
        Matcher matcher = null;
        matcher = symbolic.matcher(modeStr);
        if (matcher.find()) {
            this.applyNormalPattern(modeStr, matcher);
        } else {
            matcher = octal.matcher(modeStr);
            if (matcher.matches()) {
                this.applyOctalPattern(matcher);
            } else {
                throw new IllegalArgumentException(modeStr);
            }
        }
    }

    private void applyNormalPattern(String modeStr, Matcher matcher) {
        boolean commaSeparated = false;
        for (int i = 0; i < 1 || matcher.end() < modeStr.length(); ++i) {
            if (!(i <= 0 || commaSeparated && matcher.find())) {
                throw new IllegalArgumentException(modeStr);
            }
            String str = matcher.group(2);
            char type = str.charAt(str.length() - 1);
            boolean stickyBit = false;
            boolean others = false;
            boolean group = false;
            boolean user = false;
            block14: for (char c : matcher.group(1).toCharArray()) {
                switch (c) {
                    case 'u': {
                        user = true;
                        continue block14;
                    }
                    case 'g': {
                        group = true;
                        continue block14;
                    }
                    case 'o': {
                        others = true;
                        continue block14;
                    }
                    case 'a': {
                        continue block14;
                    }
                    default: {
                        throw new RuntimeException("Unexpected");
                    }
                }
            }
            if (!(user || group || others)) {
                others = true;
                group = true;
                user = true;
            }
            short mode = 0;
            block15: for (char c : matcher.group(3).toCharArray()) {
                switch (c) {
                    case 'r': {
                        mode = (short)(mode | 4);
                        continue block15;
                    }
                    case 'w': {
                        mode = (short)(mode | 2);
                        continue block15;
                    }
                    case 'x': {
                        mode = (short)(mode | 1);
                        continue block15;
                    }
                    case 'X': {
                        mode = (short)(mode | 8);
                        continue block15;
                    }
                    case 't': {
                        stickyBit = true;
                        continue block15;
                    }
                    default: {
                        throw new RuntimeException("Unexpected");
                    }
                }
            }
            if (user) {
                this.userMode = mode;
                this.userType = type;
            }
            if (group) {
                this.groupMode = mode;
                this.groupType = type;
            }
            if (others) {
                this.othersMode = mode;
                this.othersType = type;
                this.stickyMode = (short)(stickyBit ? 1 : 0);
                this.stickyBitType = type;
            }
            commaSeparated = matcher.group(4).contains(",");
        }
        this.symbolic = true;
    }

    private void applyOctalPattern(Matcher matcher) {
        int typeApply = 61;
        this.stickyBitType = (char)61;
        this.userType = (char)61;
        this.groupType = (char)61;
        this.othersType = (char)61;
        String sb = matcher.group(1);
        this.stickyMode = !sb.isEmpty() ? Short.valueOf(sb.substring(0, 1)) : (short)0;
        String str = matcher.group(2);
        this.userMode = Short.valueOf(str.substring(0, 1));
        this.groupMode = Short.valueOf(str.substring(1, 2));
        this.othersMode = Short.valueOf(str.substring(2, 3));
    }

    protected int combineModes(int existing, boolean exeOk) {
        return this.combineModeSegments(this.stickyBitType, this.stickyMode, existing >>> 9, false) << 9 | this.combineModeSegments(this.userType, this.userMode, existing >>> 6 & 7, exeOk) << 6 | this.combineModeSegments(this.groupType, this.groupMode, existing >>> 3 & 7, exeOk) << 3 | this.combineModeSegments(this.othersType, this.othersMode, existing & 7, exeOk);
    }

    protected int combineModeSegments(char type, int mode, int existing, boolean exeOk) {
        boolean capX = false;
        if ((mode & 8) != 0) {
            capX = true;
            mode &= 0xFFFFFFF7;
            mode |= 1;
        }
        switch (type) {
            case '+': {
                mode |= existing;
                break;
            }
            case '-': {
                mode = ~mode & existing;
                break;
            }
            case '=': {
                break;
            }
            default: {
                throw new RuntimeException("Unexpected");
            }
        }
        if (capX && !exeOk && (mode & 1) != 0 && (existing & 1) == 0) {
            mode &= 0xFFFFFFFE;
        }
        return mode;
    }
}

