/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs.permission;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.fs.permission.FsPermission;
import net.snowflake.ingest.internal.apache.hadoop.io.Text;
import net.snowflake.ingest.internal.apache.hadoop.io.Writable;
import net.snowflake.ingest.internal.apache.hadoop.io.WritableFactories;
import net.snowflake.ingest.internal.apache.hadoop.io.WritableFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class PermissionStatus
implements Writable {
    static final WritableFactory FACTORY = new WritableFactory(){

        @Override
        public Writable newInstance() {
            return new PermissionStatus();
        }
    };
    private String username;
    private String groupname;
    private FsPermission permission;

    public static PermissionStatus createImmutable(String user, String group, FsPermission permission) {
        return new PermissionStatus(user, group, permission){

            @Override
            public void readFields(DataInput in) throws IOException {
                throw new UnsupportedOperationException();
            }
        };
    }

    private PermissionStatus() {
    }

    public PermissionStatus(String user, String group, FsPermission permission) {
        this.username = user;
        this.groupname = group;
        this.permission = permission;
    }

    public String getUserName() {
        return this.username;
    }

    public String getGroupName() {
        return this.groupname;
    }

    public FsPermission getPermission() {
        return this.permission;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.username = Text.readString(in, 0x100000);
        this.groupname = Text.readString(in, 0x100000);
        this.permission = FsPermission.read(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        PermissionStatus.write(out, this.username, this.groupname, this.permission);
    }

    public static PermissionStatus read(DataInput in) throws IOException {
        PermissionStatus p = new PermissionStatus();
        p.readFields(in);
        return p;
    }

    public static void write(DataOutput out, String username, String groupname, FsPermission permission) throws IOException {
        Text.writeString(out, username, 0x100000);
        Text.writeString(out, groupname, 0x100000);
        permission.write(out);
    }

    public String toString() {
        return this.username + ":" + this.groupname + ":" + this.permission;
    }

    static {
        WritableFactories.setFactory(PermissionStatus.class, FACTORY);
    }
}

