/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs.sftp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import net.snowflake.ingest.internal.apache.hadoop.fs.FSInputStream;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileSystem;
import net.snowflake.ingest.internal.apache.hadoop.fs.Path;
import net.snowflake.ingest.internal.com.jcraft.jsch.ChannelSftp;
import net.snowflake.ingest.internal.com.jcraft.jsch.SftpATTRS;
import net.snowflake.ingest.internal.com.jcraft.jsch.SftpException;

class SFTPInputStream
extends FSInputStream {
    private final ChannelSftp channel;
    private final Path path;
    private InputStream wrappedStream;
    private FileSystem.Statistics stats;
    private boolean closed;
    private long pos;
    private long nextPos;
    private long contentLength;

    SFTPInputStream(ChannelSftp channel, Path path, FileSystem.Statistics stats) throws IOException {
        try {
            this.channel = channel;
            this.path = path;
            this.stats = stats;
            this.wrappedStream = channel.get(path.toUri().getPath());
            SftpATTRS stat = channel.lstat(path.toString());
            this.contentLength = stat.getSize();
        }
        catch (SftpException e) {
            throw new IOException(e);
        }
    }

    @Override
    public synchronized void seek(long position) throws IOException {
        this.checkNotClosed();
        if (position < 0L) {
            throw new EOFException("Cannot seek to a negative offset");
        }
        this.nextPos = position;
    }

    @Override
    public synchronized int available() throws IOException {
        this.checkNotClosed();
        long remaining = this.contentLength - this.nextPos;
        if (remaining > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)remaining;
    }

    private void seekInternal() throws IOException {
        if (this.pos == this.nextPos) {
            return;
        }
        if (this.nextPos > this.pos) {
            long skipped = this.wrappedStream.skip(this.nextPos - this.pos);
            this.pos += skipped;
        }
        if (this.nextPos < this.pos) {
            this.wrappedStream.close();
            try {
                this.wrappedStream = this.channel.get(this.path.toUri().getPath());
                this.pos = this.wrappedStream.skip(this.nextPos);
            }
            catch (SftpException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    @Override
    public synchronized long getPos() throws IOException {
        return this.nextPos;
    }

    @Override
    public synchronized int read() throws IOException {
        this.checkNotClosed();
        if (this.contentLength == 0L || this.nextPos >= this.contentLength) {
            return -1;
        }
        this.seekInternal();
        int byteRead = this.wrappedStream.read();
        if (byteRead >= 0) {
            ++this.pos;
            ++this.nextPos;
        }
        if (this.stats != null & byteRead >= 0) {
            this.stats.incrementBytesRead(1L);
        }
        return byteRead;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        super.close();
        this.wrappedStream.close();
        this.closed = true;
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException(this.path.toUri() + ": " + "Stream is closed!");
        }
    }
}

