/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs.shell;

import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.snowflake.ingest.internal.apache.hadoop.classification.VisibleForTesting;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.CommandWithDestination;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.PathData;

public abstract class CopyCommandWithMultiThread
extends CommandWithDestination {
    private int threadCount = 1;
    private ThreadPoolExecutor executor = null;
    private int threadPoolQueueSize = 1024;
    public static final int DEFAULT_QUEUE_SIZE = 1024;

    protected void setThreadCount(String optValue) {
        if (optValue != null) {
            this.threadCount = Math.max(Integer.parseInt(optValue), 1);
        }
    }

    protected void setThreadPoolQueueSize(String optValue) {
        if (optValue != null) {
            int size = Integer.parseInt(optValue);
            this.threadPoolQueueSize = size < 1 ? 1024 : size;
        }
    }

    @VisibleForTesting
    protected int getThreadCount() {
        return this.threadCount;
    }

    @VisibleForTesting
    protected int getThreadPoolQueueSize() {
        return this.threadPoolQueueSize;
    }

    @VisibleForTesting
    protected ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    @Override
    protected void processArguments(LinkedList<PathData> args) throws IOException {
        if (this.isMultiThreadNecessary(args)) {
            this.initThreadPoolExecutor();
        }
        super.processArguments(args);
        if (this.executor != null) {
            this.waitForCompletion();
        }
    }

    @VisibleForTesting
    protected boolean isMultiThreadNecessary(LinkedList<PathData> args) throws IOException {
        return this.threadCount > 1 && this.hasMoreThanOneSourcePaths(args);
    }

    private boolean hasMoreThanOneSourcePaths(LinkedList<PathData> args) throws IOException {
        if (args.size() > 1) {
            return true;
        }
        if (args.size() == 1) {
            PathData src = args.get(0);
            if (src.stat == null) {
                src.refreshStatus();
            }
            return this.isPathRecursable(src);
        }
        return false;
    }

    private void initThreadPoolExecutor() {
        this.executor = new ThreadPoolExecutor(this.threadCount, this.threadCount, 1L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.threadPoolQueueSize), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    private void waitForCompletion() {
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                this.executor.shutdownNow();
                this.displayError(e);
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    protected void copyFileToTarget(PathData src, PathData target) throws IOException {
        if (this.executor == null) {
            super.copyFileToTarget(src, target);
        } else {
            this.executor.submit(() -> {
                try {
                    super.copyFileToTarget(src, target);
                }
                catch (IOException e) {
                    this.displayError(e);
                }
            });
        }
    }
}

