/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.fs.FSDataInputStream;
import net.snowflake.ingest.internal.apache.hadoop.fs.PathIsDirectoryException;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.CommandFactory;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.CommandFormat;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.FsCommand;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.PathData;
import net.snowflake.ingest.internal.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class Head
extends FsCommand {
    public static final String NAME = "head";
    public static final String USAGE = "<file>";
    public static final String DESCRIPTION = "Show the first 1KB of the file.\n";
    private long endingOffset = 1024L;

    Head() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Head.class, "-head");
    }

    @Override
    protected void processOptions(LinkedList<String> args) throws IOException {
        CommandFormat cf = new CommandFormat(1, 1, new String[0]);
        cf.parse(args);
    }

    @Override
    protected List<PathData> expandArgument(String arg) throws IOException {
        LinkedList<PathData> items = new LinkedList<PathData>();
        items.add(new PathData(arg, this.getConf()));
        return items;
    }

    @Override
    protected void processPath(PathData item) throws IOException {
        if (item.stat.isDirectory()) {
            throw new PathIsDirectoryException(item.toString());
        }
        this.dumpToOffset(item);
    }

    private void dumpToOffset(PathData item) throws IOException {
        try (FSDataInputStream in = item.openFile("sequential");){
            IOUtils.copyBytes((InputStream)in, (OutputStream)System.out, this.endingOffset, false);
        }
    }
}

