/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs.shell.find;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.fs.Path;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.CommandFactory;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.CommandFormat;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.FsCommand;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.PathData;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.find.And;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.find.BaseExpression;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.find.Expression;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.find.ExpressionFactory;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.find.FindOptions;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.find.Name;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.find.Print;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.find.Result;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class Find
extends FsCommand {
    public static final String NAME = "find";
    public static final String USAGE = "<path> ... <expression> ...";
    public static final String DESCRIPTION;
    private static String[] HELP;
    private static final String OPTION_FOLLOW_LINK = "L";
    private static final String OPTION_FOLLOW_ARG_LINK = "H";
    private static final Set<Class<? extends Expression>> EXPRESSIONS;
    private FindOptions options;
    private Expression rootExpression;
    private HashSet<Path> stopPaths = new HashSet();

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Find.class, "-find");
    }

    private static void addExpression(Class<?> clazz) {
        EXPRESSIONS.add(clazz.asSubclass(Expression.class));
    }

    private static void registerExpressions(ExpressionFactory factory) {
        for (Class<? extends Expression> exprClass : EXPRESSIONS) {
            factory.registerExpression(exprClass);
        }
    }

    private static String buildDescription(ExpressionFactory factory) {
        ArrayList<Expression> operators = new ArrayList<Expression>();
        ArrayList<Expression> primaries = new ArrayList<Expression>();
        for (Class<? extends Expression> exprClass : EXPRESSIONS) {
            Expression expr = factory.createExpression(exprClass, null);
            if (expr.isOperator()) {
                operators.add(expr);
                continue;
            }
            primaries.add(expr);
        }
        Collections.sort(operators, new Comparator<Expression>(){

            @Override
            public int compare(Expression arg0, Expression arg1) {
                return arg0.getClass().getName().compareTo(arg1.getClass().getName());
            }
        });
        Collections.sort(primaries, new Comparator<Expression>(){

            @Override
            public int compare(Expression arg0, Expression arg1) {
                return arg0.getClass().getName().compareTo(arg1.getClass().getName());
            }
        });
        StringBuilder sb = new StringBuilder();
        for (String line : HELP) {
            sb.append(line).append("\n");
        }
        sb.append("\n").append("The following primary expressions are recognised:\n");
        for (Expression expr : primaries) {
            for (String line : expr.getUsage()) {
                sb.append("  ").append(line).append("\n");
            }
            String[] stringArray = expr.getHelp();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String line;
                line = stringArray[i];
                sb.append("    ").append(line).append("\n");
            }
            sb.append("\n");
        }
        sb.append("The following operators are recognised:\n");
        for (Expression expr : operators) {
            for (String line : expr.getUsage()) {
                sb.append("  ").append(line).append("\n");
            }
            for (String line : expr.getHelp()) {
                sb.append("    ").append(line).append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public Find() {
        this.setRecursive(true);
    }

    @Override
    protected void processOptions(LinkedList<String> args) throws IOException {
        Expression expression;
        CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, OPTION_FOLLOW_LINK, OPTION_FOLLOW_ARG_LINK, null);
        cf.parse(args);
        if (cf.getOpt(OPTION_FOLLOW_LINK)) {
            this.getOptions().setFollowLink(true);
        } else if (cf.getOpt(OPTION_FOLLOW_ARG_LINK)) {
            this.getOptions().setFollowArgLink(true);
        }
        LinkedList<String> expressionArgs = new LinkedList<String>();
        Iterator it = args.iterator();
        boolean isPath = true;
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (isPath && arg.startsWith("-")) {
                isPath = false;
            }
            if (isPath) continue;
            expressionArgs.add(arg);
            it.remove();
        }
        if (args.isEmpty()) {
            args.add(".");
        }
        if (!(expression = this.parseExpression(expressionArgs)).isAction()) {
            Expression and = this.getExpression(And.class);
            LinkedList<Expression> children = new LinkedList<Expression>();
            children.add(this.getExpression(Print.class));
            children.add(expression);
            and.addChildren(children);
            expression = and;
        }
        this.setRootExpression(expression);
    }

    @InterfaceAudience.Private
    void setRootExpression(Expression expression) {
        this.rootExpression = expression;
    }

    @InterfaceAudience.Private
    Expression getRootExpression() {
        return this.rootExpression;
    }

    @InterfaceAudience.Private
    FindOptions getOptions() {
        if (this.options == null) {
            this.options = this.createOptions();
        }
        return this.options;
    }

    private FindOptions createOptions() {
        FindOptions options = new FindOptions();
        options.setOut(this.out);
        options.setErr(this.err);
        options.setIn(System.in);
        options.setCommandFactory(this.getCommandFactory());
        options.setConfiguration(this.getConf());
        return options;
    }

    private void addStop(PathData item) {
        this.stopPaths.add(item.path);
    }

    private boolean isStop(PathData item) {
        return this.stopPaths.contains(item.path);
    }

    private Expression parseExpression(Deque<String> args) throws IOException {
        LinkedList<Expression> primaries = new LinkedList<Expression>();
        LinkedList<Expression> operators = new LinkedList<Expression>();
        Expression prevExpr = this.getExpression(And.class);
        while (!args.isEmpty()) {
            Expression expr;
            String arg = args.pop();
            if ("(".equals(arg)) {
                expr = this.parseExpression(args);
                primaries.add(expr);
                prevExpr = new BaseExpression(){

                    @Override
                    public Result apply(PathData item, int depth) throws IOException {
                        return Result.PASS;
                    }
                };
                continue;
            }
            if (")".equals(arg)) break;
            if (this.isExpression(arg)) {
                expr = this.getExpression(arg);
                expr.addArguments(args);
                if (expr.isOperator()) {
                    while (!operators.isEmpty() && ((Expression)operators.peek()).getPrecedence() >= expr.getPrecedence()) {
                        Expression op = (Expression)operators.pop();
                        op.addChildren(primaries);
                        primaries.push(op);
                    }
                    operators.push(expr);
                } else {
                    if (!prevExpr.isOperator()) {
                        Expression and = this.getExpression(And.class);
                        while (!operators.isEmpty() && ((Expression)operators.peek()).getPrecedence() >= and.getPrecedence()) {
                            Expression op = (Expression)operators.pop();
                            op.addChildren(primaries);
                            primaries.push(op);
                        }
                        operators.push(and);
                    }
                    primaries.push(expr);
                }
                prevExpr = expr;
                continue;
            }
            throw new IOException("Unexpected argument: " + arg);
        }
        while (!operators.isEmpty()) {
            Expression operator = (Expression)operators.pop();
            operator.addChildren(primaries);
            primaries.push(operator);
        }
        return primaries.isEmpty() ? this.getExpression(Print.class) : (Expression)primaries.pop();
    }

    private boolean isAncestor(PathData source, PathData target) {
        for (Path parent = source.path; parent != null && !parent.isRoot(); parent = parent.getParent()) {
            if (!parent.equals(target.path)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void recursePath(PathData item) throws IOException {
        if (this.isStop(item)) {
            return;
        }
        if (this.getDepth() >= this.getOptions().getMaxDepth()) {
            return;
        }
        if (item.stat.isSymlink() && this.getOptions().isFollowLink()) {
            PathData linkedItem = new PathData(item.stat.getSymlink().toString(), this.getConf());
            if (this.isAncestor(item, linkedItem)) {
                this.getOptions().getErr().println("Infinite loop ignored: " + item.toString() + " -> " + linkedItem.toString());
                return;
            }
            if (linkedItem.exists) {
                item = linkedItem;
            }
        }
        if (item.stat.isDirectory()) {
            super.recursePath(item);
        }
    }

    @Override
    protected boolean isPathRecursable(PathData item) throws IOException {
        if (item.stat.isDirectory()) {
            return true;
        }
        if (item.stat.isSymlink()) {
            PathData linkedItem = new PathData(item.fs.resolvePath(item.stat.getSymlink()).toString(), this.getConf());
            if (linkedItem.stat.isDirectory()) {
                if (this.getOptions().isFollowLink()) {
                    return true;
                }
                if (this.getOptions().isFollowArgLink() && this.getDepth() == 0) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected void processPath(PathData item) throws IOException {
        if (this.getOptions().isDepthFirst()) {
            return;
        }
        this.applyItem(item);
    }

    @Override
    protected void postProcessPath(PathData item) throws IOException {
        if (!this.getOptions().isDepthFirst()) {
            return;
        }
        this.applyItem(item);
    }

    private void applyItem(PathData item) throws IOException {
        Result result;
        if (this.getDepth() >= this.getOptions().getMinDepth() && Result.STOP.equals(result = this.getRootExpression().apply(item, this.getDepth()))) {
            this.addStop(item);
        }
    }

    @Override
    protected void processArguments(LinkedList<PathData> args) throws IOException {
        Expression expr = this.getRootExpression();
        expr.setOptions(this.getOptions());
        expr.prepare();
        super.processArguments(args);
        expr.finish();
    }

    private Expression getExpression(String expressionName) {
        return ExpressionFactory.getExpressionFactory().getExpression(expressionName, this.getConf());
    }

    private Expression getExpression(Class<? extends Expression> expressionClass) {
        return ExpressionFactory.getExpressionFactory().createExpression(expressionClass, this.getConf());
    }

    private boolean isExpression(String expressionName) {
        return ExpressionFactory.getExpressionFactory().isExpression(expressionName);
    }

    static {
        HELP = new String[]{"Finds all files that match the specified expression and", "applies selected actions to them. If no <path> is specified", "then defaults to the current working directory. If no", "expression is specified then defaults to -print."};
        EXPRESSIONS = new HashSet<Class<? extends Expression>>();
        Find.addExpression(And.class);
        Find.addExpression(Print.class);
        Find.addExpression(Name.class);
        DESCRIPTION = Find.buildDescription(ExpressionFactory.getExpressionFactory());
        Find.registerExpressions(ExpressionFactory.getExpressionFactory());
    }
}

