/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs.statistics.impl;

import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicLong;
import net.snowflake.ingest.internal.apache.hadoop.classification.VisibleForTesting;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.fs.impl.WeakReferenceThreadMap;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.IOStatisticsContext;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.impl.EmptyIOStatisticsContextImpl;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.impl.IOStatisticsContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOStatisticsContextIntegration {
    private static final Logger LOG = LoggerFactory.getLogger(IOStatisticsContextIntegration.class);
    private static boolean isThreadIOStatsEnabled;
    public static final AtomicLong INSTANCE_ID;
    private static final WeakReferenceThreadMap<IOStatisticsContext> ACTIVE_IOSTATS_CONTEXT;

    public static boolean isIOStatisticsThreadLevelEnabled() {
        return isThreadIOStatsEnabled;
    }

    private IOStatisticsContextIntegration() {
    }

    private static IOStatisticsContext createNewInstance(Long key) {
        IOStatisticsContextImpl instance = new IOStatisticsContextImpl(key, INSTANCE_ID.getAndIncrement());
        LOG.debug("Created instance {}", (Object)instance);
        return instance;
    }

    private static void referenceLostContext(Long key) {
        LOG.debug("Reference lost for threadID for the context: {}", (Object)key);
    }

    public static IOStatisticsContext getCurrentIOStatisticsContext() {
        return isThreadIOStatsEnabled ? ACTIVE_IOSTATS_CONTEXT.getForCurrentThread() : EmptyIOStatisticsContextImpl.getInstance();
    }

    public static void setThreadIOStatisticsContext(IOStatisticsContext statisticsContext) {
        if (isThreadIOStatsEnabled) {
            if (statisticsContext == null) {
                ACTIVE_IOSTATS_CONTEXT.removeForCurrentThread();
            } else {
                ACTIVE_IOSTATS_CONTEXT.setForCurrentThread(statisticsContext);
            }
        }
    }

    @VisibleForTesting
    public static IOStatisticsContext getThreadSpecificIOStatisticsContext(long testThreadId) {
        LOG.debug("IOStatsContext thread ID required: {}", (Object)testThreadId);
        if (!isThreadIOStatsEnabled) {
            return null;
        }
        WeakReference ioStatisticsSnapshotWeakReference = ACTIVE_IOSTATS_CONTEXT.lookup(testThreadId);
        if (ioStatisticsSnapshotWeakReference != null) {
            return (IOStatisticsContext)ioStatisticsSnapshotWeakReference.get();
        }
        return null;
    }

    @VisibleForTesting
    public static void enableIOStatisticsContext() {
        if (!isThreadIOStatsEnabled) {
            LOG.info("Enabling Thread IOStatistics..");
            isThreadIOStatsEnabled = true;
        }
    }

    static {
        INSTANCE_ID = new AtomicLong(1L);
        ACTIVE_IOSTATS_CONTEXT = new WeakReferenceThreadMap<IOStatisticsContext>(IOStatisticsContextIntegration::createNewInstance, IOStatisticsContextIntegration::referenceLostContext);
        Configuration configuration = new Configuration();
        isThreadIOStatsEnabled = configuration.getBoolean("fs.iostatistics.thread.level.enabled", true);
    }
}

