/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs.statistics.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.snowflake.ingest.internal.apache.hadoop.fs.StorageStatistics;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.IOStatistics;

public class StorageStatisticsFromIOStatistics
extends StorageStatistics
implements Iterable<StorageStatistics.LongStatistic> {
    private final IOStatistics ioStatistics;
    private final String scheme;

    public StorageStatisticsFromIOStatistics(String name, String scheme, IOStatistics ioStatistics) {
        super(name);
        this.scheme = scheme;
        this.ioStatistics = ioStatistics;
    }

    @Override
    public Iterator<StorageStatistics.LongStatistic> iterator() {
        return this.getLongStatistics();
    }

    @Override
    public Iterator<StorageStatistics.LongStatistic> getLongStatistics() {
        Set<Map.Entry<String, Long>> counters = this.counters().entrySet();
        Set statisticSet = counters.stream().map(this::toLongStatistic).collect(Collectors.toSet());
        this.gauges().entrySet().forEach(entry -> statisticSet.add(this.toLongStatistic((Map.Entry<String, Long>)entry)));
        return statisticSet.iterator();
    }

    private StorageStatistics.LongStatistic toLongStatistic(Map.Entry<String, Long> e) {
        return new StorageStatistics.LongStatistic(e.getKey(), e.getValue());
    }

    private Map<String, Long> counters() {
        return this.ioStatistics.counters();
    }

    private Map<String, Long> gauges() {
        return this.ioStatistics.gauges();
    }

    @Override
    public Long getLong(String key) {
        Long l = this.counters().get(key);
        if (l == null) {
            l = this.gauges().get(key);
        }
        return l;
    }

    @Override
    public boolean isTracked(String key) {
        return this.counters().containsKey(key) || this.gauges().containsKey(key);
    }

    @Override
    public void reset() {
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }
}

