/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.http;

import java.util.HashMap;
import net.snowflake.ingest.internal.apache.commons.logging.Log;
import net.snowflake.ingest.internal.apache.commons.logging.LogConfigurationException;
import net.snowflake.ingest.internal.apache.commons.logging.LogFactory;
import net.snowflake.ingest.internal.apache.commons.logging.impl.Log4JLogger;
import net.snowflake.ingest.internal.apache.hadoop.http.HttpRequestLogAppender;
import net.snowflake.ingest.internal.apache.log4j.Appender;
import net.snowflake.ingest.internal.org.eclipse.jetty.server.AsyncRequestLogWriter;
import net.snowflake.ingest.internal.org.eclipse.jetty.server.CustomRequestLog;
import net.snowflake.ingest.internal.org.eclipse.jetty.server.RequestLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestLog {
    public static final Logger LOG = LoggerFactory.getLogger(HttpRequestLog.class);
    private static final HashMap<String, String> serverToComponent = new HashMap();

    public static RequestLog getRequestLog(String name) {
        boolean isLog4JLogger;
        String lookup = serverToComponent.get(name);
        if (lookup != null) {
            name = lookup;
        }
        String loggerName = "http.requests." + name;
        String appenderName = name + "requestlog";
        Log logger = LogFactory.getLog(loggerName);
        try {
            isLog4JLogger = logger instanceof Log4JLogger;
        }
        catch (NoClassDefFoundError err) {
            LOG.debug("Could not load Log4JLogger class", (Throwable)err);
            isLog4JLogger = false;
        }
        if (isLog4JLogger) {
            Log4JLogger httpLog4JLog = (Log4JLogger)logger;
            net.snowflake.ingest.internal.apache.log4j.Logger httpLogger = httpLog4JLog.getLogger();
            Appender appender = null;
            try {
                appender = httpLogger.getAppender(appenderName);
            }
            catch (LogConfigurationException e) {
                LOG.warn("Http request log for {} could not be created", (Object)loggerName);
                throw e;
            }
            if (appender == null) {
                LOG.info("Http request log for {} is not defined", (Object)loggerName);
                return null;
            }
            if (appender instanceof HttpRequestLogAppender) {
                HttpRequestLogAppender requestLogAppender = (HttpRequestLogAppender)appender;
                AsyncRequestLogWriter logWriter = new AsyncRequestLogWriter();
                logWriter.setFilename(requestLogAppender.getFilename());
                logWriter.setRetainDays(requestLogAppender.getRetainDays());
                return new CustomRequestLog((RequestLog.Writer)logWriter, "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\"");
            }
            LOG.warn("Jetty request log for {} was of the wrong class", (Object)loggerName);
            return null;
        }
        LOG.warn("Jetty request log can only be enabled using Log4j");
        return null;
    }

    static {
        serverToComponent.put("cluster", "resourcemanager");
        serverToComponent.put("hdfs", "namenode");
        serverToComponent.put("node", "nodemanager");
    }
}

