/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.io;

import java.io.IOException;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileSystem;
import net.snowflake.ingest.internal.apache.hadoop.fs.Path;
import net.snowflake.ingest.internal.apache.hadoop.io.LongWritable;
import net.snowflake.ingest.internal.apache.hadoop.io.MapFile;
import net.snowflake.ingest.internal.apache.hadoop.io.SequenceFile;
import net.snowflake.ingest.internal.apache.hadoop.io.Writable;
import net.snowflake.ingest.internal.apache.hadoop.util.Progressable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ArrayFile
extends MapFile {
    protected ArrayFile() {
    }

    public static class Reader
    extends MapFile.Reader {
        private LongWritable key = new LongWritable();

        public Reader(FileSystem fs, String file, Configuration conf) throws IOException {
            super(new Path(file), conf, new SequenceFile.Reader.Option[0]);
        }

        public synchronized void seek(long n) throws IOException {
            this.key.set(n);
            this.seek(this.key);
        }

        public synchronized Writable next(Writable value) throws IOException {
            return this.next(this.key, value) ? value : null;
        }

        public synchronized long key() throws IOException {
            return this.key.get();
        }

        public synchronized Writable get(long n, Writable value) throws IOException {
            this.key.set(n);
            return this.get(this.key, value);
        }
    }

    public static class Writer
    extends MapFile.Writer {
        private LongWritable count = new LongWritable(0L);

        public Writer(Configuration conf, FileSystem fs, String file, Class<? extends Writable> valClass) throws IOException {
            super(conf, new Path(file), Writer.keyClass(LongWritable.class), Writer.valueClass(valClass));
        }

        public Writer(Configuration conf, FileSystem fs, String file, Class<? extends Writable> valClass, SequenceFile.CompressionType compress, Progressable progress) throws IOException {
            super(conf, new Path(file), Writer.keyClass(LongWritable.class), Writer.valueClass(valClass), Writer.compression(compress), Writer.progressable(progress));
        }

        public synchronized void append(Writable value) throws IOException {
            super.append(this.count, value);
            this.count.set(this.count.get() + 1L);
        }
    }
}

