/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionCodec;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionInputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionOutputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Compressor;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressorStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Decompressor;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.DecompressorStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.DefaultCodec;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.DirectDecompressor;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.zlib.BuiltInGzipDecompressor;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.zlib.ZlibCompressor;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.zlib.ZlibDecompressor;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.zlib.ZlibFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class GzipCodec
extends DefaultCodec {
    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        if (!ZlibFactory.isNativeZlibLoaded(this.conf)) {
            return new GzipOutputStream(out);
        }
        return CompressionCodec.Util.createOutputStreamWithCodecPool(this, this.conf, out);
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        return compressor != null ? new CompressorStream(out, compressor, this.conf.getInt("io.file.buffer.size", 4096)) : this.createOutputStream(out);
    }

    @Override
    public Compressor createCompressor() {
        return ZlibFactory.isNativeZlibLoaded(this.conf) ? new GzipZlibCompressor(this.conf) : null;
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        return ZlibFactory.isNativeZlibLoaded(this.conf) ? GzipZlibCompressor.class : null;
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return CompressionCodec.Util.createInputStreamWithCodecPool(this, this.conf, in);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        if (decompressor == null) {
            decompressor = this.createDecompressor();
        }
        return new DecompressorStream(in, decompressor, this.conf.getInt("io.file.buffer.size", 4096));
    }

    @Override
    public Decompressor createDecompressor() {
        return ZlibFactory.isNativeZlibLoaded(this.conf) ? new GzipZlibDecompressor() : new BuiltInGzipDecompressor();
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        return ZlibFactory.isNativeZlibLoaded(this.conf) ? GzipZlibDecompressor.class : BuiltInGzipDecompressor.class;
    }

    @Override
    public DirectDecompressor createDirectDecompressor() {
        return ZlibFactory.isNativeZlibLoaded(this.conf) ? new ZlibDecompressor.ZlibDirectDecompressor(ZlibDecompressor.CompressionHeader.AUTODETECT_GZIP_ZLIB, 0) : null;
    }

    @Override
    public String getDefaultExtension() {
        return ".gz";
    }

    static final class GzipZlibDecompressor
    extends ZlibDecompressor {
        public GzipZlibDecompressor() {
            super(ZlibDecompressor.CompressionHeader.AUTODETECT_GZIP_ZLIB, 65536);
        }
    }

    static final class GzipZlibCompressor
    extends ZlibCompressor {
        public GzipZlibCompressor() {
            super(ZlibCompressor.CompressionLevel.DEFAULT_COMPRESSION, ZlibCompressor.CompressionStrategy.DEFAULT_STRATEGY, ZlibCompressor.CompressionHeader.GZIP_FORMAT, 65536);
        }

        public GzipZlibCompressor(Configuration conf) {
            super(ZlibFactory.getCompressionLevel(conf), ZlibFactory.getCompressionStrategy(conf), ZlibCompressor.CompressionHeader.GZIP_FORMAT, 65536);
        }
    }

    @InterfaceStability.Evolving
    protected static class GzipOutputStream
    extends CompressorStream {
        public GzipOutputStream(OutputStream out) throws IOException {
            super(new ResetableGZIPOutputStream(out));
        }

        protected GzipOutputStream(CompressorStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] data, int offset, int length) throws IOException {
            this.out.write(data, offset, length);
        }

        @Override
        public void finish() throws IOException {
            ((ResetableGZIPOutputStream)this.out).finish();
        }

        @Override
        public void resetState() throws IOException {
            ((ResetableGZIPOutputStream)this.out).resetState();
        }

        private static class ResetableGZIPOutputStream
        extends GZIPOutputStream {
            private static final byte[] GZIP_HEADER = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
            private boolean reset = false;

            public ResetableGZIPOutputStream(OutputStream out) throws IOException {
                super(out);
            }

            public synchronized void resetState() throws IOException {
                this.reset = true;
            }

            @Override
            public synchronized void write(byte[] buf, int off, int len) throws IOException {
                if (this.reset) {
                    this.def.reset();
                    this.crc.reset();
                    this.out.write(GZIP_HEADER);
                    this.reset = false;
                }
                super.write(buf, off, len);
            }

            @Override
            public synchronized void close() throws IOException {
                this.reset = false;
                super.close();
            }
        }
    }
}

