/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.coder;

import java.io.IOException;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.ECBlock;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.ECChunk;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.coder.ErasureCodingStep;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;

@InterfaceAudience.Private
public class ErasureEncodingStep
implements ErasureCodingStep {
    private ECBlock[] inputBlocks;
    private ECBlock[] outputBlocks;
    private RawErasureEncoder rawEncoder;

    public ErasureEncodingStep(ECBlock[] inputBlocks, ECBlock[] outputBlocks, RawErasureEncoder rawEncoder) {
        this.inputBlocks = inputBlocks;
        this.outputBlocks = outputBlocks;
        this.rawEncoder = rawEncoder;
    }

    @Override
    public void performCoding(ECChunk[] inputChunks, ECChunk[] outputChunks) throws IOException {
        this.rawEncoder.encode(inputChunks, outputChunks);
    }

    @Override
    public ECBlock[] getInputBlocks() {
        return this.inputBlocks;
    }

    @Override
    public ECBlock[] getOutputBlocks() {
        return this.outputBlocks;
    }

    @Override
    public void finish() {
    }
}

