/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.rawcoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.rawcoder.ByteArrayEncodingState;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.rawcoder.ByteBufferEncodingState;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;
import net.snowflake.ingest.internal.apache.hadoop.util.PerformanceAdvisory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
abstract class AbstractNativeRawEncoder
extends RawErasureEncoder {
    public static Logger LOG = LoggerFactory.getLogger(AbstractNativeRawEncoder.class);
    protected final ReentrantReadWriteLock encoderLock = new ReentrantReadWriteLock();
    private long nativeCoder;

    public AbstractNativeRawEncoder(ErasureCoderOptions coderOptions) {
        super(coderOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doEncode(ByteBufferEncodingState encodingState) throws IOException {
        this.encoderLock.readLock().lock();
        try {
            ByteBuffer buffer;
            int i;
            if (this.nativeCoder == 0L) {
                throw new IOException(String.format("%s closed", this.getClass().getSimpleName()));
            }
            int[] inputOffsets = new int[encodingState.inputs.length];
            int[] outputOffsets = new int[encodingState.outputs.length];
            int dataLen = encodingState.inputs[0].remaining();
            for (i = 0; i < encodingState.inputs.length; ++i) {
                buffer = encodingState.inputs[i];
                inputOffsets[i] = buffer.position();
            }
            for (i = 0; i < encodingState.outputs.length; ++i) {
                buffer = encodingState.outputs[i];
                outputOffsets[i] = buffer.position();
            }
            this.performEncodeImpl(encodingState.inputs, inputOffsets, dataLen, encodingState.outputs, outputOffsets);
        }
        finally {
            this.encoderLock.readLock().unlock();
        }
    }

    protected abstract void performEncodeImpl(ByteBuffer[] var1, int[] var2, int var3, ByteBuffer[] var4, int[] var5) throws IOException;

    @Override
    protected void doEncode(ByteArrayEncodingState encodingState) throws IOException {
        PerformanceAdvisory.LOG.debug("convertToByteBufferState is invoked, not efficiently. Please use direct ByteBuffer inputs/outputs");
        ByteBufferEncodingState bbeState = encodingState.convertToByteBufferState();
        this.doEncode(bbeState);
        for (int i = 0; i < encodingState.outputs.length; ++i) {
            bbeState.outputs[i].get(encodingState.outputs[i], encodingState.outputOffsets[i], encodingState.encodeLength);
        }
    }

    @Override
    public boolean preferDirectBuffer() {
        return true;
    }
}

