/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.io.file.tfile;

import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.io.BytesWritable;
import net.snowflake.ingest.internal.apache.hadoop.io.file.tfile.RawComparable;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class ByteArray
implements RawComparable {
    private final byte[] buffer;
    private final int offset;
    private final int len;

    public ByteArray(BytesWritable other) {
        this(other.getBytes(), 0, other.getLength());
    }

    public ByteArray(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public ByteArray(byte[] buffer, int offset, int len) {
        if ((offset | len | buffer.length - offset - len) < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer = buffer;
        this.offset = offset;
        this.len = len;
    }

    @Override
    public byte[] buffer() {
        return this.buffer;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public int size() {
        return this.len;
    }
}

