/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.io.file.tfile;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CodecPool;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionCodec;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionInputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionOutputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Compressor;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Decompressor;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.DefaultCodec;
import net.snowflake.ingest.internal.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Compression {
    static final Logger LOG = LoggerFactory.getLogger(Compression.class);

    private Compression() {
    }

    public static Algorithm getCompressionAlgorithmByName(String compressName) {
        Algorithm[] algos;
        for (Algorithm a : algos = (Algorithm[])Algorithm.class.getEnumConstants()) {
            if (!a.getName().equals(compressName)) continue;
            return a;
        }
        throw new IllegalArgumentException("Unsupported compression algorithm name: " + compressName);
    }

    static String[] getSupportedAlgorithms() {
        Algorithm[] algos = (Algorithm[])Algorithm.class.getEnumConstants();
        ArrayList<String> ret = new ArrayList<String>();
        for (Algorithm a : algos) {
            if (!a.isSupported()) continue;
            ret.add(a.getName());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static enum Algorithm {
        LZO("lzo"){
            private transient boolean checked = false;
            private transient ClassNotFoundException cnf;
            private transient boolean reinitCodecInTests;
            private static final String defaultClazz = "net.snowflake.ingest.internal.apache.hadoop.io.compress.LzoCodec";
            private transient String clazz;
            private transient CompressionCodec codec = null;

            private String getLzoCodecClass() {
                String extClazzConf = conf.get(Algorithm.CONF_LZO_CLASS);
                String extClazz = extClazzConf != null ? extClazzConf : System.getProperty(Algorithm.CONF_LZO_CLASS);
                return extClazz != null ? extClazz : defaultClazz;
            }

            @Override
            public synchronized boolean isSupported() {
                if (!this.checked || this.reinitCodecInTests) {
                    this.checked = true;
                    this.reinitCodecInTests = conf.getBoolean("test.reload.lzo.codec", false);
                    this.clazz = this.getLzoCodecClass();
                    try {
                        LOG.info("Trying to load Lzo codec class: " + this.clazz);
                        this.codec = (CompressionCodec)ReflectionUtils.newInstance(Class.forName(this.clazz), conf);
                    }
                    catch (ClassNotFoundException e) {
                        this.cnf = e;
                    }
                }
                return this.codec != null;
            }

            @Override
            CompressionCodec getCodec() throws IOException {
                if (!this.isSupported()) {
                    throw new IOException(String.format("LZO codec %s=%s could not be loaded", Algorithm.CONF_LZO_CLASS, this.clazz), this.cnf);
                }
                return this.codec;
            }

            @Override
            public synchronized InputStream createDecompressionStream(InputStream downStream, Decompressor decompressor, int downStreamBufferSize) throws IOException {
                if (!this.isSupported()) {
                    throw new IOException("LZO codec class not specified. Did you forget to set property io.compression.codec.lzo.class?");
                }
                InputStream bis1 = null;
                bis1 = downStreamBufferSize > 0 ? new BufferedInputStream(downStream, downStreamBufferSize) : downStream;
                conf.setInt("io.compression.codec.lzo.buffersize", 65536);
                CompressionInputStream cis = this.codec.createInputStream(bis1, decompressor);
                BufferedInputStream bis2 = new BufferedInputStream(cis, 1024);
                return bis2;
            }

            @Override
            public synchronized OutputStream createCompressionStream(OutputStream downStream, Compressor compressor, int downStreamBufferSize) throws IOException {
                if (!this.isSupported()) {
                    throw new IOException("LZO codec class not specified. Did you forget to set property io.compression.codec.lzo.class?");
                }
                OutputStream bos1 = null;
                bos1 = downStreamBufferSize > 0 ? new BufferedOutputStream(downStream, downStreamBufferSize) : downStream;
                conf.setInt("io.compression.codec.lzo.buffersize", 65536);
                CompressionOutputStream cos = this.codec.createOutputStream(bos1, compressor);
                BufferedOutputStream bos2 = new BufferedOutputStream(new FinishOnFlushCompressionStream(cos), 4096);
                return bos2;
            }
        }
        ,
        GZ("gz"){
            private transient DefaultCodec codec;

            @Override
            CompressionCodec getCodec() {
                if (this.codec == null) {
                    this.codec = new DefaultCodec();
                    this.codec.setConf(conf);
                }
                return this.codec;
            }

            @Override
            public synchronized InputStream createDecompressionStream(InputStream downStream, Decompressor decompressor, int downStreamBufferSize) throws IOException {
                if (downStreamBufferSize > 0) {
                    this.codec.getConf().setInt("io.file.buffer.size", downStreamBufferSize);
                }
                CompressionInputStream cis = this.codec.createInputStream(downStream, decompressor);
                BufferedInputStream bis2 = new BufferedInputStream(cis, 1024);
                return bis2;
            }

            @Override
            public synchronized OutputStream createCompressionStream(OutputStream downStream, Compressor compressor, int downStreamBufferSize) throws IOException {
                OutputStream bos1 = null;
                bos1 = downStreamBufferSize > 0 ? new BufferedOutputStream(downStream, downStreamBufferSize) : downStream;
                this.codec.getConf().setInt("io.file.buffer.size", 32768);
                CompressionOutputStream cos = this.codec.createOutputStream(bos1, compressor);
                BufferedOutputStream bos2 = new BufferedOutputStream(new FinishOnFlushCompressionStream(cos), 4096);
                return bos2;
            }

            @Override
            public boolean isSupported() {
                return true;
            }
        }
        ,
        NONE("none"){

            @Override
            CompressionCodec getCodec() {
                return null;
            }

            @Override
            public synchronized InputStream createDecompressionStream(InputStream downStream, Decompressor decompressor, int downStreamBufferSize) throws IOException {
                if (downStreamBufferSize > 0) {
                    return new BufferedInputStream(downStream, downStreamBufferSize);
                }
                return downStream;
            }

            @Override
            public synchronized OutputStream createCompressionStream(OutputStream downStream, Compressor compressor, int downStreamBufferSize) throws IOException {
                if (downStreamBufferSize > 0) {
                    return new BufferedOutputStream(downStream, downStreamBufferSize);
                }
                return downStream;
            }

            @Override
            public boolean isSupported() {
                return true;
            }
        };

        protected static final Configuration conf;
        private final String compressName;
        private static final int DATA_IBUF_SIZE = 1024;
        private static final int DATA_OBUF_SIZE = 4096;
        public static final String CONF_LZO_CLASS = "io.compression.codec.lzo.class";

        private Algorithm(String name) {
            this.compressName = name;
        }

        abstract CompressionCodec getCodec() throws IOException;

        public abstract InputStream createDecompressionStream(InputStream var1, Decompressor var2, int var3) throws IOException;

        public abstract OutputStream createCompressionStream(OutputStream var1, Compressor var2, int var3) throws IOException;

        public abstract boolean isSupported();

        public Compressor getCompressor() throws IOException {
            CompressionCodec codec = this.getCodec();
            if (codec != null) {
                Compressor compressor = CodecPool.getCompressor(codec);
                if (compressor != null) {
                    if (compressor.finished()) {
                        LOG.warn("Compressor obtained from CodecPool already finished()");
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Got a compressor: " + compressor.hashCode());
                    }
                    compressor.reset();
                }
                return compressor;
            }
            return null;
        }

        public void returnCompressor(Compressor compressor) {
            if (compressor != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Return a compressor: " + compressor.hashCode());
                }
                CodecPool.returnCompressor(compressor);
            }
        }

        public Decompressor getDecompressor() throws IOException {
            CompressionCodec codec = this.getCodec();
            if (codec != null) {
                Decompressor decompressor = CodecPool.getDecompressor(codec);
                if (decompressor != null) {
                    if (decompressor.finished()) {
                        LOG.warn("Deompressor obtained from CodecPool already finished()");
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Got a decompressor: " + decompressor.hashCode());
                    }
                    decompressor.reset();
                }
                return decompressor;
            }
            return null;
        }

        public void returnDecompressor(Decompressor decompressor) {
            if (decompressor != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Returned a decompressor: " + decompressor.hashCode());
                }
                CodecPool.returnDecompressor(decompressor);
            }
        }

        public String getName() {
            return this.compressName;
        }

        static {
            conf = new Configuration();
        }
    }

    static class FinishOnFlushCompressionStream
    extends FilterOutputStream {
        public FinishOnFlushCompressionStream(CompressionOutputStream cout) {
            super(cout);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            CompressionOutputStream cout = (CompressionOutputStream)this.out;
            cout.finish();
            cout.flush();
            cout.resetState();
        }
    }
}

