/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.security;

import java.io.IOException;
import java.util.List;
import net.snowflake.ingest.internal.apache.hadoop.security.GroupMappingServiceProvider;
import net.snowflake.ingest.internal.apache.hadoop.security.JniBasedUnixGroupsMapping;
import net.snowflake.ingest.internal.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import net.snowflake.ingest.internal.apache.hadoop.util.NativeCodeLoader;
import net.snowflake.ingest.internal.apache.hadoop.util.PerformanceAdvisory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JniBasedUnixGroupsMappingWithFallback
implements GroupMappingServiceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(JniBasedUnixGroupsMappingWithFallback.class);
    private GroupMappingServiceProvider impl;

    public JniBasedUnixGroupsMappingWithFallback() {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            this.impl = new JniBasedUnixGroupsMapping();
        } else {
            PerformanceAdvisory.LOG.debug("Falling back to shell based");
            this.impl = new ShellBasedUnixGroupsMapping();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Group mapping impl=" + this.impl.getClass().getName());
        }
    }

    @Override
    public List<String> getGroups(String user) throws IOException {
        return this.impl.getGroups(user);
    }

    @Override
    public void cacheGroupsRefresh() throws IOException {
        this.impl.cacheGroupsRefresh();
    }

    @Override
    public void cacheGroupsAdd(List<String> groups) throws IOException {
        this.impl.cacheGroupsAdd(groups);
    }
}

