/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.security.http;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.org.eclipse.jetty.server.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RestCsrfPreventionFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(RestCsrfPreventionFilter.class);
    public static final String HEADER_USER_AGENT = "User-Agent";
    public static final String BROWSER_USER_AGENT_PARAM = "browser-useragents-regex";
    public static final String CUSTOM_HEADER_PARAM = "custom-header";
    public static final String CUSTOM_METHODS_TO_IGNORE_PARAM = "methods-to-ignore";
    static final String BROWSER_USER_AGENTS_DEFAULT = "^Mozilla.*,^Opera.*";
    public static final String HEADER_DEFAULT = "X-XSRF-HEADER";
    static final String METHODS_TO_IGNORE_DEFAULT = "GET,OPTIONS,HEAD,TRACE";
    private String headerName = "X-XSRF-HEADER";
    private Set<String> methodsToIgnore = null;
    private Set<Pattern> browserUserAgents;

    public void init(FilterConfig filterConfig) throws ServletException {
        String customMethodsToIgnore;
        String customHeader = filterConfig.getInitParameter(CUSTOM_HEADER_PARAM);
        if (customHeader != null) {
            this.headerName = customHeader;
        }
        if ((customMethodsToIgnore = filterConfig.getInitParameter(CUSTOM_METHODS_TO_IGNORE_PARAM)) != null) {
            this.parseMethodsToIgnore(customMethodsToIgnore);
        } else {
            this.parseMethodsToIgnore(METHODS_TO_IGNORE_DEFAULT);
        }
        String agents = filterConfig.getInitParameter(BROWSER_USER_AGENT_PARAM);
        if (agents == null) {
            agents = BROWSER_USER_AGENTS_DEFAULT;
        }
        this.parseBrowserUserAgents(agents);
        LOG.info("Adding cross-site request forgery (CSRF) protection, headerName = {}, methodsToIgnore = {}, browserUserAgents = {}", new Object[]{this.headerName, this.methodsToIgnore, this.browserUserAgents});
    }

    void parseBrowserUserAgents(String userAgents) {
        String[] agentsArray = userAgents.split(",");
        this.browserUserAgents = new HashSet<Pattern>();
        for (String patternString : agentsArray) {
            this.browserUserAgents.add(Pattern.compile(patternString));
        }
    }

    void parseMethodsToIgnore(String mti) {
        String[] methods = mti.split(",");
        this.methodsToIgnore = new HashSet<String>();
        for (int i = 0; i < methods.length; ++i) {
            this.methodsToIgnore.add(methods[i]);
        }
    }

    protected boolean isBrowser(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        for (Pattern pattern : this.browserUserAgents) {
            Matcher matcher = pattern.matcher(userAgent);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    public void handleHttpInteraction(HttpInteraction httpInteraction) throws IOException, ServletException {
        if (!this.isBrowser(httpInteraction.getHeader(HEADER_USER_AGENT)) || this.methodsToIgnore.contains(httpInteraction.getMethod()) || httpInteraction.getHeader(this.headerName) != null) {
            httpInteraction.proceed();
        } else {
            httpInteraction.sendError(400, "Missing Required Header for CSRF Vulnerability Protection");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        this.handleHttpInteraction(new ServletFilterHttpInteraction(httpRequest, httpResponse, chain));
    }

    public void destroy() {
    }

    public static Map<String, String> getFilterParams(Configuration conf, String confPrefix) {
        return conf.getPropsWithPrefix(confPrefix);
    }

    private static final class ServletFilterHttpInteraction
    implements HttpInteraction {
        private final FilterChain chain;
        private final HttpServletRequest httpRequest;
        private final HttpServletResponse httpResponse;

        public ServletFilterHttpInteraction(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) {
            this.httpRequest = httpRequest;
            this.httpResponse = httpResponse;
            this.chain = chain;
        }

        @Override
        public String getHeader(String header) {
            return this.httpRequest.getHeader(header);
        }

        @Override
        public String getMethod() {
            return this.httpRequest.getMethod();
        }

        @Override
        public void proceed() throws IOException, ServletException {
            this.chain.doFilter((ServletRequest)this.httpRequest, (ServletResponse)this.httpResponse);
        }

        @Override
        public void sendError(int code, String message) throws IOException {
            if (this.httpResponse instanceof Response) {
                ((Response)this.httpResponse).setStatusWithReason(code, message);
            }
            this.httpResponse.sendError(code, message);
        }
    }

    public static interface HttpInteraction {
        public String getHeader(String var1);

        public String getMethod();

        public void proceed() throws IOException, ServletException;

        public void sendError(int var1, String var2) throws IOException;
    }
}

