/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.security.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import net.snowflake.ingest.internal.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.openssl.OpenSSLProvider;

public final class DelegatingSSLSocketFactory
extends SSLSocketFactory {
    private static DelegatingSSLSocketFactory instance = null;
    private static final Logger LOG = LoggerFactory.getLogger(DelegatingSSLSocketFactory.class);
    private String providerName;
    private SSLContext ctx;
    private String[] ciphers;
    private SSLChannelMode channelMode;
    private boolean openSSLProviderRegistered;

    public static synchronized void initializeDefaultFactory(SSLChannelMode preferredMode) throws IOException {
        if (instance == null) {
            instance = new DelegatingSSLSocketFactory(preferredMode);
        }
    }

    @VisibleForTesting
    public static synchronized void resetDefaultFactory() {
        LOG.info("Resetting default SSL Socket Factory");
        instance = null;
    }

    public static DelegatingSSLSocketFactory getDefaultFactory() {
        return instance;
    }

    private DelegatingSSLSocketFactory(SSLChannelMode preferredChannelMode) throws IOException {
        try {
            this.initializeSSLContext(preferredChannelMode);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        SSLSocketFactory factory = this.ctx.getSocketFactory();
        String[] defaultCiphers = factory.getSupportedCipherSuites();
        String version = System.getProperty("java.version");
        this.ciphers = this.channelMode == SSLChannelMode.Default_JSSE && version.startsWith("1.8") ? this.alterCipherList(defaultCiphers) : defaultCiphers;
        this.providerName = this.ctx.getProvider().getName() + "-" + this.ctx.getProvider().getVersion();
    }

    private void initializeSSLContext(SSLChannelMode preferredChannelMode) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        LOG.debug("Initializing SSL Context to channel mode {}", (Object)preferredChannelMode);
        switch (preferredChannelMode) {
            case Default: {
                try {
                    this.bindToOpenSSLProvider();
                    this.channelMode = SSLChannelMode.OpenSSL;
                }
                catch (LinkageError | RuntimeException | NoSuchAlgorithmException e) {
                    LOG.debug("Failed to load OpenSSL. Falling back to the JSSE default.", e);
                    this.ctx = SSLContext.getDefault();
                    this.channelMode = SSLChannelMode.Default_JSSE;
                }
                break;
            }
            case OpenSSL: {
                this.bindToOpenSSLProvider();
                this.channelMode = SSLChannelMode.OpenSSL;
                break;
            }
            case Default_JSSE: {
                this.ctx = SSLContext.getDefault();
                this.channelMode = SSLChannelMode.Default_JSSE;
                break;
            }
            case Default_JSSE_with_GCM: {
                this.ctx = SSLContext.getDefault();
                this.channelMode = SSLChannelMode.Default_JSSE_with_GCM;
                break;
            }
            default: {
                throw new IOException("Unknown channel mode: " + (Object)((Object)preferredChannelMode));
            }
        }
    }

    private void bindToOpenSSLProvider() throws NoSuchAlgorithmException, KeyManagementException {
        if (!this.openSSLProviderRegistered) {
            LOG.debug("Attempting to register OpenSSL provider");
            OpenSSLProvider.register();
            this.openSSLProviderRegistered = true;
        }
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger("org.wildfly.openssl.SSL");
        Level originalLevel = logger.getLevel();
        try {
            logger.setLevel(Level.WARNING);
            this.ctx = SSLContext.getInstance("openssl.TLS");
            this.ctx.init(null, null, null);
        }
        finally {
            logger.setLevel(originalLevel);
        }
    }

    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return (String[])this.ciphers.clone();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return (String[])this.ciphers.clone();
    }

    public SSLChannelMode getChannelMode() {
        return this.channelMode;
    }

    @Override
    public Socket createSocket() throws IOException {
        SSLSocketFactory factory = this.ctx.getSocketFactory();
        return this.configureSocket(factory.createSocket());
    }

    @Override
    public Socket createSocket(Socket s2, String host, int port, boolean autoClose) throws IOException {
        SSLSocketFactory factory = this.ctx.getSocketFactory();
        return this.configureSocket(factory.createSocket(s2, host, port, autoClose));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocketFactory factory = this.ctx.getSocketFactory();
        return this.configureSocket(factory.createSocket(address, port, localAddress, localPort));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        SSLSocketFactory factory = this.ctx.getSocketFactory();
        return this.configureSocket(factory.createSocket(host, port, localHost, localPort));
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocketFactory factory = this.ctx.getSocketFactory();
        return this.configureSocket(factory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SSLSocketFactory factory = this.ctx.getSocketFactory();
        return this.configureSocket(factory.createSocket(host, port));
    }

    private Socket configureSocket(Socket socket) {
        ((SSLSocket)socket).setEnabledCipherSuites(this.ciphers);
        return socket;
    }

    private String[] alterCipherList(String[] defaultCiphers) {
        ArrayList<String> preferredSuites = new ArrayList<String>();
        for (int i = 0; i < defaultCiphers.length; ++i) {
            if (defaultCiphers[i].contains("_GCM_")) {
                LOG.debug("Removed Cipher - {} from list of enabled SSLSocket ciphers", (Object)defaultCiphers[i]);
                continue;
            }
            preferredSuites.add(defaultCiphers[i]);
        }
        this.ciphers = preferredSuites.toArray(new String[0]);
        return this.ciphers;
    }

    public static enum SSLChannelMode {
        OpenSSL,
        Default,
        Default_JSSE,
        Default_JSSE_with_GCM;

    }
}

