/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.thirdparty.org.checkerframework.checker.nullness;

import net.snowflake.ingest.internal.apache.hadoop.thirdparty.org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import net.snowflake.ingest.internal.apache.hadoop.thirdparty.org.checkerframework.checker.nullness.qual.NonNull;
import net.snowflake.ingest.internal.apache.hadoop.thirdparty.org.checkerframework.checker.nullness.qual.Nullable;

public final class NullnessUtil {
    private NullnessUtil() {
        throw new AssertionError((Object)"shouldn't be instantiated");
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T castNonNull(@Nullable T ref) {
        assert (ref != null) : "Misuse of castNonNull: called with a null argument";
        return ref;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T castNonNull(@Nullable T ref, String message) {
        assert (ref != null) : "Misuse of castNonNull: called with a null argument: " + message;
        return ref;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [] castNonNullDeep(T @Nullable [] arr) {
        return NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [] castNonNullDeep(T @Nullable [] arr, String message) {
        return NullnessUtil.castNonNullArray(arr, message);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][] castNonNullDeep(T @Nullable [] @Nullable [] arr) {
        return (Object[][])NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][] castNonNullDeep(T @Nullable [] @Nullable [] arr, String message) {
        return (Object[][])NullnessUtil.castNonNullArray(arr, message);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] arr) {
        return (Object[][][])NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] arr, String message) {
        return (Object[][][])NullnessUtil.castNonNullArray(arr, message);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] @Nullable [] arr) {
        return (Object[][][][])NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] @Nullable [] arr, String message) {
        return (Object[][][][])NullnessUtil.castNonNullArray(arr, message);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] @Nullable [] @Nullable [] arr) {
        return (Object[][][][][])NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] @Nullable [] @Nullable [] arr, String message) {
        return (Object[][][][][])NullnessUtil.castNonNullArray(arr, message);
    }

    private static <T> @NonNull T @NonNull [] castNonNullArray(T @Nullable [] arr, @Nullable String message) {
        assert (arr != null) : "Misuse of castNonNullArray: called with a null array argument" + (message == null ? "" : ": " + message);
        for (int i = 0; i < arr.length; ++i) {
            assert (arr[i] != null) : "Misuse of castNonNull: called with a null array element" + (message == null ? "" : ": " + message);
            NullnessUtil.checkIfArray(arr[i], message);
        }
        return arr;
    }

    private static void checkIfArray(@NonNull Object ref, @Nullable String message) {
        assert (ref != null) : "Misuse of checkIfArray: called with a null argument" + (message == null ? "" : ": " + message);
        Class<?> comp = ref.getClass().getComponentType();
        if (comp != null && !comp.isPrimitive()) {
            NullnessUtil.castNonNullArray((Object[])ref, message);
        }
    }
}

