/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.util;

import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.util.IndexedSortable;
import net.snowflake.ingest.internal.apache.hadoop.util.IndexedSorter;
import net.snowflake.ingest.internal.apache.hadoop.util.Progressable;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class HeapSort
implements IndexedSorter {
    private static void downHeap(IndexedSortable s2, int b, int i, int N2) {
        int idx = i << 1;
        while (idx < N2) {
            if (idx + 1 < N2 && s2.compare(b + idx, b + idx + 1) < 0) {
                if (s2.compare(b + i, b + idx + 1) >= 0) {
                    return;
                }
                s2.swap(b + i, b + idx + 1);
                i = idx + 1;
            } else if (s2.compare(b + i, b + idx) < 0) {
                s2.swap(b + i, b + idx);
                i = idx;
            } else {
                return;
            }
            idx = i << 1;
        }
    }

    @Override
    public void sort(IndexedSortable s2, int p, int r) {
        this.sort(s2, p, r, null);
    }

    @Override
    public void sort(IndexedSortable s2, int p, int r, Progressable rep) {
        int t2;
        int i;
        int N2 = r - p;
        for (i = t2 = Integer.highestOneBit(N2); i > 1; i >>>= 1) {
            for (int j = i >>> 1; j < i; ++j) {
                HeapSort.downHeap(s2, p - 1, j, N2 + 1);
            }
            if (null == rep) continue;
            rep.progress();
        }
        for (i = r - 1; i > p; --i) {
            s2.swap(p, i);
            HeapSort.downHeap(s2, p - 1, 1, i - p + 1);
        }
    }
}

