/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.util.functional;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.snowflake.ingest.internal.apache.hadoop.util.DurationInfo;
import net.snowflake.ingest.internal.apache.hadoop.util.functional.FutureIO;
import net.snowflake.ingest.internal.javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonCallableSupplier<T>
implements Supplier {
    private static final Logger LOG = LoggerFactory.getLogger(CommonCallableSupplier.class);
    private final Callable<T> call;

    public CommonCallableSupplier(Callable<T> call) {
        this.call = call;
    }

    public Object get() {
        try {
            return this.call.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (Exception e) {
            throw new UncheckedIOException(new IOException(e));
        }
    }

    public static <T> CompletableFuture<T> submit(Executor executor, Callable<T> call) {
        return CompletableFuture.supplyAsync(new CommonCallableSupplier<T>(call), executor);
    }

    public static <T> void waitForCompletion(List<CompletableFuture<T>> futures) throws IOException {
        if (futures.isEmpty()) {
            return;
        }
        CommonCallableSupplier.waitForCompletion(CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])));
    }

    public static <T> void waitForCompletion(CompletableFuture<T> future) throws IOException {
        try (DurationInfo ignore = new DurationInfo(LOG, false, "Waiting for task completion", new Object[0]);){
            future.join();
        }
        catch (CancellationException e) {
            throw new IOException(e);
        }
        catch (CompletionException e) {
            FutureIO.raiseInnerCause(e);
        }
    }

    public static <T> void waitForCompletionIgnoringExceptions(@Nullable CompletableFuture<T> future) {
        if (future != null) {
            try (DurationInfo ignore = new DurationInfo(LOG, false, "Waiting for task completion", new Object[0]);){
                future.join();
            }
            catch (Exception e) {
                LOG.debug("Ignoring exception raised in task completion: ");
            }
        }
    }

    public static void maybeAwaitCompletion(@Nullable CompletableFuture<Void> future) throws IOException {
        if (future != null) {
            CommonCallableSupplier.waitForCompletion(future);
        }
    }
}

