/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.column.statistics;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.snowflake.ingest.internal.apache.parquet.Preconditions;
import net.snowflake.ingest.internal.apache.parquet.io.api.Binary;
import net.snowflake.ingest.internal.apache.parquet.schema.PrimitiveType;
import net.snowflake.ingest.internal.shaded.parquet.it.unimi.dsi.fastutil.longs.LongArrayList;

public class SizeStatistics {
    private final PrimitiveType type;
    private long unencodedByteArrayDataBytes;
    private final List<Long> repetitionLevelHistogram;
    private final List<Long> definitionLevelHistogram;
    private boolean valid = true;

    public static Builder newBuilder(PrimitiveType type, int maxRepetitionLevel, int maxDefinitionLevel) {
        return new Builder(type, maxRepetitionLevel, maxDefinitionLevel);
    }

    public SizeStatistics(PrimitiveType type, long unencodedByteArrayDataBytes, List<Long> repetitionLevelHistogram, List<Long> definitionLevelHistogram) {
        this.type = type;
        this.unencodedByteArrayDataBytes = unencodedByteArrayDataBytes;
        this.repetitionLevelHistogram = repetitionLevelHistogram;
        this.definitionLevelHistogram = definitionLevelHistogram;
    }

    public void mergeStatistics(SizeStatistics other) {
        int i;
        if (!this.valid) {
            return;
        }
        if (other == null || !other.isValid()) {
            this.valid = false;
            this.unencodedByteArrayDataBytes = 0L;
            this.repetitionLevelHistogram.clear();
            this.definitionLevelHistogram.clear();
            return;
        }
        Preconditions.checkArgument(this.type.equals((Object)other.type), "Cannot merge SizeStatistics of different types");
        this.unencodedByteArrayDataBytes = Math.addExact(this.unencodedByteArrayDataBytes, other.unencodedByteArrayDataBytes);
        for (i = 0; i < this.repetitionLevelHistogram.size(); ++i) {
            this.repetitionLevelHistogram.set(i, Math.addExact(this.repetitionLevelHistogram.get(i), other.repetitionLevelHistogram.get(i)));
        }
        for (i = 0; i < this.definitionLevelHistogram.size(); ++i) {
            this.definitionLevelHistogram.set(i, Math.addExact(this.definitionLevelHistogram.get(i), other.getDefinitionLevelHistogram().get(i)));
        }
    }

    public PrimitiveType getType() {
        return this.type;
    }

    public Optional<Long> getUnencodedByteArrayDataBytes() {
        if (this.type.getPrimitiveTypeName() != PrimitiveType.PrimitiveTypeName.BINARY) {
            return Optional.empty();
        }
        return Optional.of(this.unencodedByteArrayDataBytes);
    }

    public List<Long> getRepetitionLevelHistogram() {
        return Collections.unmodifiableList(this.repetitionLevelHistogram);
    }

    public List<Long> getDefinitionLevelHistogram() {
        return Collections.unmodifiableList(this.definitionLevelHistogram);
    }

    public SizeStatistics copy() {
        return new SizeStatistics(this.type, this.unencodedByteArrayDataBytes, new LongArrayList(this.repetitionLevelHistogram), new LongArrayList(this.definitionLevelHistogram));
    }

    public boolean isValid() {
        return this.valid;
    }

    public static class Builder {
        private final PrimitiveType type;
        private long unencodedByteArrayDataBytes;
        private final long[] repetitionLevelHistogram;
        private final long[] definitionLevelHistogram;

        private Builder(PrimitiveType type, int maxRepetitionLevel, int maxDefinitionLevel) {
            this.type = type;
            this.unencodedByteArrayDataBytes = 0L;
            this.repetitionLevelHistogram = new long[maxRepetitionLevel + 1];
            this.definitionLevelHistogram = new long[maxDefinitionLevel + 1];
        }

        public void add(int repetitionLevel, int definitionLevel) {
            int n = repetitionLevel;
            this.repetitionLevelHistogram[n] = this.repetitionLevelHistogram[n] + 1L;
            int n2 = definitionLevel;
            this.definitionLevelHistogram[n2] = this.definitionLevelHistogram[n2] + 1L;
        }

        public void add(int repetitionLevel, int definitionLevel, Binary value) {
            this.add(repetitionLevel, definitionLevel);
            if (this.type.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.BINARY && value != null) {
                this.unencodedByteArrayDataBytes += (long)value.length();
            }
        }

        public SizeStatistics build() {
            return new SizeStatistics(this.type, this.unencodedByteArrayDataBytes, new LongArrayList(this.repetitionLevelHistogram), new LongArrayList(this.definitionLevelHistogram));
        }
    }
}

