/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.crypto;

import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.fs.Path;
import net.snowflake.ingest.internal.apache.parquet.crypto.FileEncryptionProperties;
import net.snowflake.ingest.internal.apache.parquet.crypto.ParquetCryptoRuntimeException;
import net.snowflake.ingest.internal.apache.parquet.hadoop.BadConfigurationException;
import net.snowflake.ingest.internal.apache.parquet.hadoop.api.WriteSupport;
import net.snowflake.ingest.internal.apache.parquet.hadoop.util.ConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface EncryptionPropertiesFactory {
    public static final Logger LOG = LoggerFactory.getLogger(EncryptionPropertiesFactory.class);
    public static final String CRYPTO_FACTORY_CLASS_PROPERTY_NAME = "parquet.crypto.factory.class";

    public static EncryptionPropertiesFactory loadFactory(Configuration conf) {
        Class<?> encryptionPropertiesFactoryClass = ConfigurationUtil.getClassFromConfig(conf, CRYPTO_FACTORY_CLASS_PROPERTY_NAME, EncryptionPropertiesFactory.class);
        if (null == encryptionPropertiesFactoryClass) {
            LOG.debug("EncryptionPropertiesFactory is not configured - name not found in hadoop config");
            return null;
        }
        try {
            return (EncryptionPropertiesFactory)encryptionPropertiesFactoryClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new BadConfigurationException("could not instantiate encryptionPropertiesFactoryClass class: " + encryptionPropertiesFactoryClass, e);
        }
    }

    public FileEncryptionProperties getFileEncryptionProperties(Configuration var1, Path var2, WriteSupport.WriteContext var3) throws ParquetCryptoRuntimeException;
}

