/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.glob;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.snowflake.ingest.internal.apache.parquet.glob.GlobNode;
import net.snowflake.ingest.internal.apache.parquet.glob.GlobParser;

public final class GlobExpander {
    private GlobExpander() {
    }

    public static List<String> expand(String globPattern) {
        return GlobExpanderImpl.expand(GlobParser.parse(globPattern));
    }

    private static final class GlobExpanderImpl
    implements GlobNode.Visitor<List<String>> {
        private static final GlobExpanderImpl INSTANCE = new GlobExpanderImpl();

        private GlobExpanderImpl() {
        }

        public static List<String> expand(GlobNode node) {
            return node.accept(INSTANCE);
        }

        @Override
        public List<String> visit(GlobNode.Atom atom) {
            return Collections.singletonList(atom.get());
        }

        @Override
        public List<String> visit(GlobNode.OneOf oneOf) {
            ArrayList<String> results = new ArrayList<String>();
            for (GlobNode n : oneOf.getChildren()) {
                results.addAll((Collection<String>)n.accept(this));
            }
            return results;
        }

        @Override
        public List<String> visit(GlobNode.GlobNodeSequence seq) {
            List<String> results = new ArrayList<String>();
            for (GlobNode n : seq.getChildren()) {
                results = GlobExpanderImpl.crossOrTakeNonEmpty(results, n.accept(this));
            }
            return results;
        }

        public static List<String> crossOrTakeNonEmpty(List<String> list1, List<String> list2) {
            if (list1.isEmpty()) {
                ArrayList<String> result = new ArrayList<String>(list2.size());
                result.addAll(list2);
                return result;
            }
            if (list2.isEmpty()) {
                ArrayList<String> result = new ArrayList<String>(list1.size());
                result.addAll(list1);
                return result;
            }
            ArrayList<String> result = new ArrayList<String>(list1.size() * list2.size());
            for (String s1 : list1) {
                for (String s2 : list2) {
                    result.add(s1 + s2);
                }
            }
            return result;
        }
    }
}

