/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.hadoop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.parquet.column.ColumnDescriptor;
import net.snowflake.ingest.internal.apache.parquet.column.ParquetProperties;
import net.snowflake.ingest.internal.apache.parquet.column.values.factory.DefaultV1ValuesWriterFactory;
import net.snowflake.ingest.internal.apache.parquet.crypto.FileEncryptionProperties;
import net.snowflake.ingest.internal.apache.parquet.hadoop.CodecFactory;
import net.snowflake.ingest.internal.apache.parquet.hadoop.InternalParquetRecordWriter;
import net.snowflake.ingest.internal.apache.parquet.hadoop.ParquetFileWriter;
import net.snowflake.ingest.internal.apache.parquet.hadoop.api.WriteSupport;
import net.snowflake.ingest.internal.apache.parquet.hadoop.metadata.BlockMetaData;
import net.snowflake.ingest.internal.apache.parquet.io.DelegatingPositionOutputStream;
import net.snowflake.ingest.internal.apache.parquet.io.OutputFile;
import net.snowflake.ingest.internal.apache.parquet.io.ParquetEncodingException;
import net.snowflake.ingest.internal.apache.parquet.io.PositionOutputStream;
import net.snowflake.ingest.internal.apache.parquet.io.api.Binary;
import net.snowflake.ingest.internal.apache.parquet.io.api.RecordConsumer;
import net.snowflake.ingest.internal.apache.parquet.schema.MessageType;
import net.snowflake.ingest.internal.apache.parquet.schema.PrimitiveType;
import net.snowflake.ingest.utils.Constants;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.SFException;

public class BdecParquetWriter
implements AutoCloseable {
    private final InternalParquetRecordWriter<List<Object>> writer;
    private final CodecFactory codecFactory;
    private long rowsWritten = 0L;

    public BdecParquetWriter(ByteArrayOutputStream stream, MessageType schema, Map<String, String> extraMetaData, String channelName, long maxChunkSizeInBytes, Constants.BdecParquetCompression bdecParquetCompression) throws IOException {
        ByteArrayOutputFile file = new ByteArrayOutputFile(stream, maxChunkSizeInBytes);
        ParquetProperties encodingProps = BdecParquetWriter.createParquetProperties();
        Configuration conf = new Configuration();
        BdecWriteSupport writeSupport = new BdecWriteSupport(schema, extraMetaData, channelName);
        WriteSupport.WriteContext writeContext = ((WriteSupport)writeSupport).init(conf);
        ParquetFileWriter fileWriter = new ParquetFileWriter((OutputFile)file, schema, ParquetFileWriter.Mode.CREATE, 0x80000000L, 0x800000, encodingProps.getColumnIndexTruncateLength(), encodingProps.getStatisticsTruncateLength(), encodingProps.getPageWriteChecksumEnabled(), (FileEncryptionProperties)null);
        fileWriter.start();
        this.codecFactory = new CodecFactory(conf, 0x100000);
        CodecFactory.BytesCompressor compressor = this.codecFactory.getCompressor(bdecParquetCompression.getCompressionCodec());
        this.writer = new InternalParquetRecordWriter<List<Object>>(fileWriter, writeSupport, schema, writeContext.getExtraMetaData(), 0x80000000L, compressor, true, encodingProps);
    }

    public List<Long> getRowCountsFromFooter() {
        ArrayList<Long> blockRowCounts = new ArrayList<Long>();
        for (BlockMetaData metadata : this.writer.getFooter().getBlocks()) {
            blockRowCounts.add(metadata.getRowCount());
        }
        return blockRowCounts;
    }

    public void writeRow(List<Object> row) {
        try {
            this.writer.write(row);
            ++this.rowsWritten;
        }
        catch (IOException | InterruptedException e) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, "parquet row write failed", e);
        }
    }

    public long getRowsWritten() {
        return this.rowsWritten;
    }

    @Override
    public void close() throws IOException {
        try {
            this.writer.close();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            this.codecFactory.release();
        }
    }

    private static ParquetProperties createParquetProperties() {
        return ParquetProperties.builder().withWriterVersion(ParquetProperties.WriterVersion.PARQUET_1_0).withValuesWriterFactory(new DefaultV1ValuesWriterFactory()).withDictionaryEncoding(false).withPageRowCountLimit(Integer.MAX_VALUE).withMinRowCountForPageSizeCheck(Integer.MAX_VALUE).build();
    }

    private static class BdecWriteSupport
    extends WriteSupport<List<Object>> {
        MessageType schema;
        RecordConsumer recordConsumer;
        Map<String, String> extraMetadata;
        private final String channelName;

        BdecWriteSupport(MessageType schema, Map<String, String> extraMetadata, String channelName) {
            this.schema = schema;
            this.extraMetadata = extraMetadata;
            this.channelName = channelName;
        }

        @Override
        public WriteSupport.WriteContext init(Configuration config) {
            return new WriteSupport.WriteContext(this.schema, this.extraMetadata);
        }

        @Override
        public void prepareForWrite(RecordConsumer recordConsumer) {
            this.recordConsumer = recordConsumer;
        }

        @Override
        public void write(List<Object> values) {
            List<ColumnDescriptor> cols = this.schema.getColumns();
            if (values.size() != cols.size()) {
                throw new ParquetEncodingException("Invalid input data in channel '" + this.channelName + "'. Expecting " + cols.size() + " columns. Input had " + values.size() + " columns (" + cols + ") : " + values);
            }
            this.recordConsumer.startMessage();
            for (int i = 0; i < cols.size(); ++i) {
                Object val = values.get(i);
                if (val == null) continue;
                String fieldName = cols.get(i).getPath()[0];
                this.recordConsumer.startField(fieldName, i);
                PrimitiveType.PrimitiveTypeName typeName = cols.get(i).getPrimitiveType().getPrimitiveTypeName();
                switch (typeName) {
                    case BOOLEAN: {
                        this.recordConsumer.addBoolean((Boolean)val);
                        break;
                    }
                    case FLOAT: {
                        this.recordConsumer.addFloat(((Float)val).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        this.recordConsumer.addDouble((Double)val);
                        break;
                    }
                    case INT32: {
                        this.recordConsumer.addInteger((Integer)val);
                        break;
                    }
                    case INT64: {
                        this.recordConsumer.addLong((Long)val);
                        break;
                    }
                    case BINARY: {
                        Binary binVal = val instanceof String ? Binary.fromString((String)val) : Binary.fromConstantByteArray((byte[])val);
                        this.recordConsumer.addBinary(binVal);
                        break;
                    }
                    case FIXED_LEN_BYTE_ARRAY: {
                        Binary binary = Binary.fromConstantByteArray((byte[])val);
                        this.recordConsumer.addBinary(binary);
                        break;
                    }
                    default: {
                        throw new ParquetEncodingException("Unsupported column type: " + cols.get(i).getPrimitiveType());
                    }
                }
                this.recordConsumer.endField(fieldName, i);
            }
            this.recordConsumer.endMessage();
        }
    }

    private static class ByteArrayDelegatingPositionOutputStream
    extends DelegatingPositionOutputStream {
        private final ByteArrayOutputStream stream;

        public ByteArrayDelegatingPositionOutputStream(ByteArrayOutputStream stream) {
            super(stream);
            this.stream = stream;
        }

        @Override
        public long getPos() {
            return this.stream.size();
        }
    }

    private static class ByteArrayOutputFile
    implements OutputFile {
        private final ByteArrayOutputStream stream;
        private final long maxChunkSizeInBytes;

        private ByteArrayOutputFile(ByteArrayOutputStream stream, long maxChunkSizeInBytes) {
            this.stream = stream;
            this.maxChunkSizeInBytes = maxChunkSizeInBytes;
        }

        @Override
        public PositionOutputStream create(long blockSizeHint) throws IOException {
            this.stream.reset();
            return new ByteArrayDelegatingPositionOutputStream(this.stream);
        }

        @Override
        public PositionOutputStream createOrOverwrite(long blockSizeHint) throws IOException {
            return this.create(blockSizeHint);
        }

        @Override
        public boolean supportsBlockSize() {
            return false;
        }

        @Override
        public long defaultBlockSize() {
            return this.maxChunkSizeInBytes;
        }
    }
}

