/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.hadoop;

import java.io.IOException;
import java.util.Set;
import net.snowflake.ingest.internal.apache.parquet.column.values.bloomfilter.BloomFilter;
import net.snowflake.ingest.internal.apache.parquet.hadoop.NoneIndexCache;
import net.snowflake.ingest.internal.apache.parquet.hadoop.ParquetFileReader;
import net.snowflake.ingest.internal.apache.parquet.hadoop.PrefetchIndexCache;
import net.snowflake.ingest.internal.apache.parquet.hadoop.metadata.BlockMetaData;
import net.snowflake.ingest.internal.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import net.snowflake.ingest.internal.apache.parquet.hadoop.metadata.ColumnPath;
import net.snowflake.ingest.internal.apache.parquet.internal.column.columnindex.ColumnIndex;
import net.snowflake.ingest.internal.apache.parquet.internal.column.columnindex.OffsetIndex;

public interface IndexCache {
    public static IndexCache create(ParquetFileReader fileReader, Set<ColumnPath> columns, CacheStrategy cacheStrategy, boolean freeCacheAfterGet) {
        if (cacheStrategy == CacheStrategy.NONE) {
            return new NoneIndexCache(fileReader);
        }
        if (cacheStrategy == CacheStrategy.PREFETCH_BLOCK) {
            return new PrefetchIndexCache(fileReader, columns, freeCacheAfterGet);
        }
        throw new UnsupportedOperationException("Unknown cache strategy: " + (Object)((Object)cacheStrategy));
    }

    public void setBlockMetadata(BlockMetaData var1) throws IOException;

    public ColumnIndex getColumnIndex(ColumnChunkMetaData var1) throws IOException;

    public OffsetIndex getOffsetIndex(ColumnChunkMetaData var1) throws IOException;

    public BloomFilter getBloomFilter(ColumnChunkMetaData var1) throws IOException;

    public void clean();

    public static enum CacheStrategy {
        NONE,
        PREFETCH_BLOCK;

    }
}

