/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.hadoop.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configurable;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionCodec;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionInputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionOutputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Compressor;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Decompressor;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.DirectDecompressionCodec;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.DirectDecompressor;
import net.snowflake.ingest.internal.apache.parquet.hadoop.codec.Lz4RawCompressor;
import net.snowflake.ingest.internal.apache.parquet.hadoop.codec.Lz4RawDecompressor;
import net.snowflake.ingest.internal.apache.parquet.hadoop.codec.NonBlockedCompressorStream;
import net.snowflake.ingest.internal.apache.parquet.hadoop.codec.NonBlockedDecompressorStream;

public class Lz4RawCodec
implements Configurable,
CompressionCodec,
DirectDecompressionCodec {
    private Configuration conf;
    public static final String BUFFER_SIZE_CONFIG = "io.file.buffer.size";
    private static final int DEFAULT_BUFFER_SIZE_CONFIG = 4096;

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public Compressor createCompressor() {
        return new Lz4RawCompressor();
    }

    @Override
    public Decompressor createDecompressor() {
        return new Lz4RawDecompressor();
    }

    @Override
    public DirectDecompressor createDirectDecompressor() {
        return new Lz4RawDecompressor();
    }

    @Override
    public CompressionInputStream createInputStream(InputStream stream) throws IOException {
        return this.createInputStream(stream, this.createDecompressor());
    }

    @Override
    public CompressionInputStream createInputStream(InputStream stream, Decompressor decompressor) throws IOException {
        return new NonBlockedDecompressorStream(stream, decompressor, this.conf.getInt(BUFFER_SIZE_CONFIG, 4096));
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream stream) throws IOException {
        return this.createOutputStream(stream, this.createCompressor());
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream stream, Compressor compressor) throws IOException {
        return new NonBlockedCompressorStream(stream, compressor, this.conf.getInt(BUFFER_SIZE_CONFIG, 4096));
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        return Lz4RawCompressor.class;
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        return Lz4RawDecompressor.class;
    }

    @Override
    public String getDefaultExtension() {
        return ".lz4";
    }
}

