/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.hadoop.codec;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.DirectDecompressor;
import net.snowflake.ingest.internal.apache.parquet.hadoop.codec.NonBlockedDecompressor;
import net.snowflake.ingest.internal.io.airlift.compress.lz4.Lz4Decompressor;

public class Lz4RawDecompressor
extends NonBlockedDecompressor
implements DirectDecompressor {
    private Lz4Decompressor decompressor = new Lz4Decompressor();

    @Override
    protected int maxUncompressedLength(ByteBuffer compressed, int maxUncompressedLength) throws IOException {
        return maxUncompressedLength;
    }

    @Override
    protected int uncompress(ByteBuffer compressed, ByteBuffer uncompressed) throws IOException {
        this.decompressor.decompress(compressed, uncompressed);
        int uncompressedSize = uncompressed.position();
        uncompressed.limit(uncompressedSize);
        uncompressed.rewind();
        return uncompressedSize;
    }

    @Override
    public void decompress(ByteBuffer compressed, ByteBuffer uncompressed) throws IOException {
        this.uncompress(compressed, uncompressed);
    }
}

