/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.hadoop.codec;

import java.io.IOException;
import java.io.InputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Decompressor;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.DecompressorStream;

public class NonBlockedDecompressorStream
extends DecompressorStream {
    private boolean inputHandled;

    public NonBlockedDecompressorStream(InputStream stream, Decompressor decompressor, int bufferSize) throws IOException {
        super(stream, decompressor, bufferSize);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.inputHandled) {
            int compressedBytes;
            while ((compressedBytes = this.getCompressedData()) != -1) {
                this.decompressor.setInput(this.buffer, 0, compressedBytes);
            }
            this.inputHandled = true;
        }
        int decompressedBytes = this.decompressor.decompress(b, off, len);
        if (this.decompressor.finished()) {
            this.decompressor.reset();
        }
        if (decompressedBytes == 0) {
            throw new IOException("Corrupt file: Zero bytes read during decompression.");
        }
        return decompressedBytes;
    }
}

