/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.hadoop.example;

import java.util.Map;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.parquet.conf.HadoopParquetConfiguration;
import net.snowflake.ingest.internal.apache.parquet.conf.ParquetConfiguration;
import net.snowflake.ingest.internal.apache.parquet.example.data.Group;
import net.snowflake.ingest.internal.apache.parquet.example.data.simple.convert.GroupRecordConverter;
import net.snowflake.ingest.internal.apache.parquet.hadoop.api.ReadSupport;
import net.snowflake.ingest.internal.apache.parquet.io.api.RecordMaterializer;
import net.snowflake.ingest.internal.apache.parquet.schema.MessageType;

public class GroupReadSupport
extends ReadSupport<Group> {
    @Override
    public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        return this.init(new HadoopParquetConfiguration(configuration), keyValueMetaData, fileSchema);
    }

    @Override
    public ReadSupport.ReadContext init(ParquetConfiguration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        String partialSchemaString = configuration.get("parquet.read.schema");
        MessageType requestedProjection = GroupReadSupport.getSchemaForRead(fileSchema, partialSchemaString);
        return new ReadSupport.ReadContext(requestedProjection);
    }

    @Override
    public RecordMaterializer<Group> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        return new GroupRecordConverter(readContext.getRequestedSchema());
    }

    @Override
    public RecordMaterializer<Group> prepareForRead(ParquetConfiguration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        return new GroupRecordConverter(readContext.getRequestedSchema());
    }
}

