/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.internal.column.columnindex;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.snowflake.ingest.internal.apache.parquet.filter2.predicate.Statistics;
import net.snowflake.ingest.internal.apache.parquet.internal.column.columnindex.ColumnIndexBuilder;
import net.snowflake.ingest.internal.apache.parquet.io.api.Binary;
import net.snowflake.ingest.internal.apache.parquet.schema.PrimitiveComparator;
import net.snowflake.ingest.internal.apache.parquet.schema.PrimitiveType;
import net.snowflake.ingest.internal.shaded.parquet.it.unimi.dsi.fastutil.ints.IntArrayList;
import net.snowflake.ingest.internal.shaded.parquet.it.unimi.dsi.fastutil.ints.IntList;

class IntColumnIndexBuilder
extends ColumnIndexBuilder {
    private final IntList minValues = new IntArrayList();
    private final IntList maxValues = new IntArrayList();

    IntColumnIndexBuilder() {
    }

    private static int convert(ByteBuffer buffer) {
        return buffer.order(ByteOrder.LITTLE_ENDIAN).getInt(0);
    }

    private static ByteBuffer convert(int value) {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(0, value);
    }

    @Override
    void addMinMaxFromBytes(ByteBuffer min2, ByteBuffer max) {
        this.minValues.add(IntColumnIndexBuilder.convert(min2));
        this.maxValues.add(IntColumnIndexBuilder.convert(max));
    }

    @Override
    void addMinMax(Object min2, Object max) {
        this.minValues.add((int)((Integer)min2));
        this.maxValues.add((int)((Integer)max));
    }

    ColumnIndexBuilder.ColumnIndexBase<Integer> createColumnIndex(PrimitiveType type) {
        IntColumnIndex columnIndex = new IntColumnIndex(type);
        IntColumnIndex.access$102(columnIndex, this.minValues.toIntArray());
        IntColumnIndex.access$202(columnIndex, this.maxValues.toIntArray());
        return columnIndex;
    }

    @Override
    void clearMinMax() {
        this.minValues.clear();
        this.maxValues.clear();
    }

    @Override
    int compareMinValues(PrimitiveComparator<Binary> comparator, int index1, int index2) {
        return comparator.compare(this.minValues.get(index1), this.minValues.get(index2));
    }

    @Override
    int compareMaxValues(PrimitiveComparator<Binary> comparator, int index1, int index2) {
        return comparator.compare(this.maxValues.get(index1), this.maxValues.get(index2));
    }

    @Override
    int sizeOf(Object value) {
        return 4;
    }

    @Override
    public long getMinMaxSize() {
        return (long)this.minValues.size() * 4L + (long)this.maxValues.size() * 4L;
    }

    private static class IntColumnIndex
    extends ColumnIndexBuilder.ColumnIndexBase<Integer> {
        private int[] minValues;
        private int[] maxValues;

        private IntColumnIndex(PrimitiveType type) {
            super(type);
        }

        @Override
        ByteBuffer getMinValueAsBytes(int pageIndex) {
            return IntColumnIndexBuilder.convert(this.minValues[pageIndex]);
        }

        @Override
        ByteBuffer getMaxValueAsBytes(int pageIndex) {
            return IntColumnIndexBuilder.convert(this.maxValues[pageIndex]);
        }

        @Override
        String getMinValueAsString(int pageIndex) {
            return this.stringifier.stringify(this.minValues[pageIndex]);
        }

        @Override
        String getMaxValueAsString(int pageIndex) {
            return this.stringifier.stringify(this.maxValues[pageIndex]);
        }

        @Override
        <T extends Comparable<T>> Statistics<T> createStats(int arrayIndex) {
            return new Statistics<Integer>(this.minValues[arrayIndex], this.maxValues[arrayIndex], this.comparator);
        }

        @Override
        ColumnIndexBuilder.ColumnIndexBase.ValueComparator createValueComparator(Object value) {
            final int v = (Integer)value;
            return new ColumnIndexBuilder.ColumnIndexBase.ValueComparator(){

                @Override
                int compareValueToMin(int arrayIndex) {
                    return comparator.compare(v, minValues[arrayIndex]);
                }

                @Override
                int compareValueToMax(int arrayIndex) {
                    return comparator.compare(v, maxValues[arrayIndex]);
                }
            };
        }

        static /* synthetic */ int[] access$102(IntColumnIndex x0, int[] x1) {
            x0.minValues = x1;
            return x1;
        }

        static /* synthetic */ int[] access$202(IntColumnIndex x0, int[] x1) {
            x0.maxValues = x1;
            return x1;
        }
    }
}

