/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.com.nimbusds.jose.crypto;

import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.snowflake.ingest.internal.com.nimbusds.jose.EncryptionMethod;
import net.snowflake.ingest.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.ingest.internal.com.nimbusds.jose.JWEAlgorithm;
import net.snowflake.ingest.internal.com.nimbusds.jose.JWECryptoParts;
import net.snowflake.ingest.internal.com.nimbusds.jose.JWEEncrypter;
import net.snowflake.ingest.internal.com.nimbusds.jose.JWEHeader;
import net.snowflake.ingest.internal.com.nimbusds.jose.KeyLengthException;
import net.snowflake.ingest.internal.com.nimbusds.jose.crypto.impl.AAD;
import net.snowflake.ingest.internal.com.nimbusds.jose.crypto.impl.AESCryptoProvider;
import net.snowflake.ingest.internal.com.nimbusds.jose.crypto.impl.AESGCM;
import net.snowflake.ingest.internal.com.nimbusds.jose.crypto.impl.AESGCMKW;
import net.snowflake.ingest.internal.com.nimbusds.jose.crypto.impl.AESKW;
import net.snowflake.ingest.internal.com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import net.snowflake.ingest.internal.com.nimbusds.jose.crypto.impl.AuthenticatedCipherText;
import net.snowflake.ingest.internal.com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import net.snowflake.ingest.internal.com.nimbusds.jose.crypto.impl.JWEHeaderValidation;
import net.snowflake.ingest.internal.com.nimbusds.jose.jwk.OctetSequenceKey;
import net.snowflake.ingest.internal.com.nimbusds.jose.util.Base64URL;
import net.snowflake.ingest.internal.com.nimbusds.jose.util.ByteUtils;
import net.snowflake.ingest.internal.com.nimbusds.jose.util.Container;
import net.snowflake.ingest.internal.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class AESEncrypter
extends AESCryptoProvider
implements JWEEncrypter {
    public AESEncrypter(SecretKey kek, SecretKey contentEncryptionKey) throws KeyLengthException {
        super(kek, contentEncryptionKey);
    }

    public AESEncrypter(SecretKey kek) throws KeyLengthException {
        this(kek, null);
    }

    public AESEncrypter(byte[] keyBytes) throws KeyLengthException {
        this(new SecretKeySpec(keyBytes, "AES"));
    }

    public AESEncrypter(OctetSequenceKey octJWK) throws KeyLengthException {
        this(octJWK.toSecretKey("AES"));
    }

    @Deprecated
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText) throws JOSEException {
        return this.encrypt(header, clearText, AAD.compute(header));
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText, byte[] aad) throws JOSEException {
        JWEHeader updatedHeader;
        Base64URL encryptedKey;
        AlgFamily algFamily;
        JWEAlgorithm alg = JWEHeaderValidation.getAlgorithmAndEnsureNotNull(header);
        EncryptionMethod enc = header.getEncryptionMethod();
        if (alg.equals(JWEAlgorithm.A128KW)) {
            if (ByteUtils.safeBitLength(this.getKey().getEncoded()) != 128) {
                throw new KeyLengthException("The Key Encryption Key (KEK) length must be 128 bits for A128KW encryption");
            }
            algFamily = AlgFamily.AESKW;
        } else if (alg.equals(JWEAlgorithm.A192KW)) {
            if (ByteUtils.safeBitLength(this.getKey().getEncoded()) != 192) {
                throw new KeyLengthException("The Key Encryption Key (KEK) length must be 192 bits for A192KW encryption");
            }
            algFamily = AlgFamily.AESKW;
        } else if (alg.equals(JWEAlgorithm.A256KW)) {
            if (ByteUtils.safeBitLength(this.getKey().getEncoded()) != 256) {
                throw new KeyLengthException("The Key Encryption Key (KEK) length must be 256 bits for A256KW encryption");
            }
            algFamily = AlgFamily.AESKW;
        } else if (alg.equals(JWEAlgorithm.A128GCMKW)) {
            if (ByteUtils.safeBitLength(this.getKey().getEncoded()) != 128) {
                throw new KeyLengthException("The Key Encryption Key (KEK) length must be 128 bits for A128GCMKW encryption");
            }
            algFamily = AlgFamily.AESGCMKW;
        } else if (alg.equals(JWEAlgorithm.A192GCMKW)) {
            if (ByteUtils.safeBitLength(this.getKey().getEncoded()) != 192) {
                throw new KeyLengthException("The Key Encryption Key (KEK) length must be 192 bits for A192GCMKW encryption");
            }
            algFamily = AlgFamily.AESGCMKW;
        } else if (alg.equals(JWEAlgorithm.A256GCMKW)) {
            if (ByteUtils.safeBitLength(this.getKey().getEncoded()) != 256) {
                throw new KeyLengthException("The Key Encryption Key (KEK) length must be 256 bits for A256GCMKW encryption");
            }
            algFamily = AlgFamily.AESGCMKW;
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(alg, SUPPORTED_ALGORITHMS));
        }
        SecretKey cek = this.getCEK(enc);
        if (AlgFamily.AESKW.equals((Object)algFamily)) {
            encryptedKey = Base64URL.encode(AESKW.wrapCEK(cek, this.getKey(), this.getJCAContext().getKeyEncryptionProvider()));
            updatedHeader = header;
        } else if (AlgFamily.AESGCMKW.equals((Object)algFamily)) {
            Container<byte[]> keyIV = new Container<byte[]>(AESGCM.generateIV(this.getJCAContext().getSecureRandom()));
            AuthenticatedCipherText authCiphCEK = AESGCMKW.encryptCEK(cek, keyIV, this.getKey(), this.getJCAContext().getKeyEncryptionProvider());
            encryptedKey = Base64URL.encode(authCiphCEK.getCipherText());
            updatedHeader = new JWEHeader.Builder(header).iv(Base64URL.encode(keyIV.get())).authTag(Base64URL.encode(authCiphCEK.getAuthenticationTag())).build();
        } else {
            throw new JOSEException("Unexpected JWE algorithm: " + alg);
        }
        byte[] updatedAAD = Arrays.equals(AAD.compute(header), aad) ? AAD.compute(updatedHeader) : aad;
        return ContentCryptoProvider.encrypt(updatedHeader, clearText, updatedAAD, cek, encryptedKey, this.getJCAContext());
    }

    private static enum AlgFamily {
        AESKW,
        AESGCMKW;

    }
}

