/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.com.nimbusds.jose.crypto;

import java.util.Collections;
import java.util.Set;
import javax.crypto.SecretKey;
import net.snowflake.ingest.internal.com.nimbusds.jose.CriticalHeaderParamsAware;
import net.snowflake.ingest.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.ingest.internal.com.nimbusds.jose.JWEDecrypter;
import net.snowflake.ingest.internal.com.nimbusds.jose.JWEHeader;
import net.snowflake.ingest.internal.com.nimbusds.jose.crypto.impl.AAD;
import net.snowflake.ingest.internal.com.nimbusds.jose.crypto.impl.CriticalHeaderParamsDeferral;
import net.snowflake.ingest.internal.com.nimbusds.jose.crypto.impl.ECDH1PU;
import net.snowflake.ingest.internal.com.nimbusds.jose.crypto.impl.ECDH1PUCryptoProvider;
import net.snowflake.ingest.internal.com.nimbusds.jose.jwk.Curve;
import net.snowflake.ingest.internal.com.nimbusds.jose.jwk.OctetKeyPair;
import net.snowflake.ingest.internal.com.nimbusds.jose.util.Base64URL;
import net.snowflake.ingest.internal.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ECDH1PUX25519Decrypter
extends ECDH1PUCryptoProvider
implements JWEDecrypter,
CriticalHeaderParamsAware {
    private final OctetKeyPair privateKey;
    private final OctetKeyPair publicKey;
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();

    public ECDH1PUX25519Decrypter(OctetKeyPair privateKey, OctetKeyPair publicKey) throws JOSEException {
        this(privateKey, publicKey, null);
    }

    public ECDH1PUX25519Decrypter(OctetKeyPair privateKey, OctetKeyPair publicKey, Set<String> defCritHeaders) throws JOSEException {
        super(privateKey.getCurve(), null);
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.critPolicy.setDeferredCriticalHeaderParams(defCritHeaders);
    }

    @Override
    public Set<Curve> supportedEllipticCurves() {
        return Collections.singleton(Curve.X25519);
    }

    public OctetKeyPair getPrivateKey() {
        return this.privateKey;
    }

    public OctetKeyPair getPublicKey() {
        return this.publicKey;
    }

    @Override
    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Deprecated
    public byte[] decrypt(JWEHeader header, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL authTag) throws JOSEException {
        return this.decrypt(header, encryptedKey, iv, cipherText, authTag, AAD.compute(header));
    }

    @Override
    public byte[] decrypt(JWEHeader header, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL authTag, byte[] aad) throws JOSEException {
        this.critPolicy.ensureHeaderPasses(header);
        OctetKeyPair ephemeralPublicKey = (OctetKeyPair)header.getEphemeralPublicKey();
        if (ephemeralPublicKey == null) {
            throw new JOSEException("Missing ephemeral public key \"epk\" JWE header parameter");
        }
        SecretKey Z = ECDH1PU.deriveRecipientZ(this.privateKey, this.publicKey, ephemeralPublicKey);
        return this.decryptWithZ(header, aad, Z, encryptedKey, iv, cipherText, authTag);
    }
}

