/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.fasterxml.jackson.datatype.jdk8;

import java.io.IOException;
import java.util.OptionalInt;
import net.snowflake.ingest.internal.fasterxml.jackson.core.JsonGenerator;
import net.snowflake.ingest.internal.fasterxml.jackson.core.JsonParser;
import net.snowflake.ingest.internal.fasterxml.jackson.databind.JavaType;
import net.snowflake.ingest.internal.fasterxml.jackson.databind.JsonMappingException;
import net.snowflake.ingest.internal.fasterxml.jackson.databind.SerializerProvider;
import net.snowflake.ingest.internal.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import net.snowflake.ingest.internal.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import net.snowflake.ingest.internal.fasterxml.jackson.databind.ser.std.StdScalarSerializer;

final class OptionalIntSerializer
extends StdScalarSerializer<OptionalInt> {
    private static final long serialVersionUID = 1L;
    static final OptionalIntSerializer INSTANCE = new OptionalIntSerializer();

    public OptionalIntSerializer() {
        super(OptionalInt.class);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, OptionalInt value) {
        return value == null || !value.isPresent();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonIntegerFormatVisitor v2 = visitor.expectIntegerFormat(typeHint);
        if (v2 != null) {
            v2.numberType(JsonParser.NumberType.INT);
        }
    }

    @Override
    public void serialize(OptionalInt value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (value.isPresent()) {
            gen.writeNumber(value.getAsInt());
        } else {
            gen.writeNull();
        }
    }
}

