/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.io.airlift.compress.hadoop;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionInputStream;
import net.snowflake.ingest.internal.io.airlift.compress.hadoop.HadoopInputStream;

final class CompressionInputStreamAdapter
extends CompressionInputStream {
    private static final InputStream FAKE_INPUT_STREAM = new InputStream(){

        @Override
        public int read() {
            throw new UnsupportedOperationException();
        }
    };
    private final HadoopInputStream input;
    private final PositionSupplier positionSupplier;

    public CompressionInputStreamAdapter(HadoopInputStream input, PositionSupplier positionSupplier) throws IOException {
        super(FAKE_INPUT_STREAM);
        this.input = Objects.requireNonNull(input, "input is null");
        this.positionSupplier = Objects.requireNonNull(positionSupplier, "positionSupplier is null");
    }

    @Override
    public int read() throws IOException {
        return this.input.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.input.read(b, off, len);
    }

    @Override
    public long getPos() throws IOException {
        return this.positionSupplier.getPosition();
    }

    @Override
    public void resetState() {
        this.input.resetState();
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.input.close();
        }
    }

    public static interface PositionSupplier {
        public long getPosition() throws IOException;
    }
}

