/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.io.airlift.compress.zstd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import net.snowflake.ingest.internal.io.airlift.compress.hadoop.HadoopInputStream;
import net.snowflake.ingest.internal.io.airlift.compress.hadoop.HadoopOutputStream;
import net.snowflake.ingest.internal.io.airlift.compress.hadoop.HadoopStreams;
import net.snowflake.ingest.internal.io.airlift.compress.zstd.ZstdHadoopInputStream;
import net.snowflake.ingest.internal.io.airlift.compress.zstd.ZstdHadoopOutputStream;

public class ZstdHadoopStreams
implements HadoopStreams {
    @Override
    public String getDefaultFileExtension() {
        return ".zst";
    }

    @Override
    public List<String> getHadoopCodecName() {
        return Collections.singletonList("net.snowflake.ingest.internal.apache.hadoop.io.compress.ZStandardCodec");
    }

    @Override
    public HadoopInputStream createInputStream(InputStream in) throws IOException {
        return new ZstdHadoopInputStream(in);
    }

    @Override
    public HadoopOutputStream createOutputStream(OutputStream out) throws IOException {
        return new ZstdHadoopOutputStream(out);
    }
}

