/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.io.airlift.compress.zstd;

import java.util.Arrays;
import net.snowflake.ingest.internal.io.airlift.compress.MalformedInputException;
import net.snowflake.ingest.internal.io.airlift.compress.zstd.FrameHeader;
import net.snowflake.ingest.internal.io.airlift.compress.zstd.UnsafeUtil;
import net.snowflake.ingest.internal.io.airlift.compress.zstd.Util;
import net.snowflake.ingest.internal.io.airlift.compress.zstd.XxHash64;
import net.snowflake.ingest.internal.io.airlift.compress.zstd.ZstdFrameDecompressor;
import sun.misc.Unsafe;

public class ZstdIncrementalFrameDecompressor {
    private final ZstdFrameDecompressor frameDecompressor = new ZstdFrameDecompressor();
    private State state = State.INITIAL;
    private FrameHeader frameHeader;
    private int blockHeader = -1;
    private int inputConsumed;
    private int outputBufferUsed;
    private int inputRequired;
    private int requestedOutputSize;
    private byte[] windowBase = new byte[0];
    private long windowAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET;
    private long windowLimit = Unsafe.ARRAY_BYTE_BASE_OFFSET;
    private long windowPosition = Unsafe.ARRAY_BYTE_BASE_OFFSET;
    private XxHash64 partialHash;

    public boolean isAtStoppingPoint() {
        return this.state == State.READ_FRAME_MAGIC;
    }

    public int getInputConsumed() {
        return this.inputConsumed;
    }

    public int getOutputBufferUsed() {
        return this.outputBufferUsed;
    }

    public int getInputRequired() {
        return this.inputRequired;
    }

    public int getRequestedOutputSize() {
        return this.requestedOutputSize;
    }

    public void partialDecompress(Object inputBase, long inputAddress, long inputLimit, byte[] outputArray, int outputOffset, int outputLimit) {
        if ((long)this.inputRequired > inputLimit - inputAddress) {
            throw new IllegalArgumentException(String.format("Required %s input bytes, but only %s input bytes were supplied", this.inputRequired, inputLimit - inputAddress));
        }
        if (this.requestedOutputSize > 0 && outputOffset >= outputLimit) {
            throw new IllegalArgumentException("Not enough space in output buffer to output");
        }
        long input = inputAddress;
        int output = outputOffset;
        while (true) {
            boolean lastBlock;
            int flushableOutputSize;
            if ((flushableOutputSize = this.computeFlushableOutputSize(this.frameHeader)) > 0) {
                int freeOutputSize = outputLimit - output;
                if (freeOutputSize > 0) {
                    int copySize = Math.min(freeOutputSize, flushableOutputSize);
                    System.arraycopy(this.windowBase, Math.toIntExact(this.windowAddress - (long)Unsafe.ARRAY_BYTE_BASE_OFFSET), outputArray, output, copySize);
                    if (this.partialHash != null) {
                        this.partialHash.update(outputArray, output, copySize);
                    }
                    this.windowAddress += (long)copySize;
                    output += copySize;
                    flushableOutputSize -= copySize;
                }
                if (flushableOutputSize > 0) {
                    this.requestOutput(inputAddress, outputOffset, input, output, flushableOutputSize);
                    return;
                }
            }
            Util.checkState(this.computeFlushableOutputSize(this.frameHeader) == 0, "Expected output to be flushed");
            if (this.state == State.READ_FRAME_MAGIC || this.state == State.INITIAL) {
                if (inputLimit - input < 4L) {
                    this.inputRequired(inputAddress, outputOffset, input, output, 4);
                    return;
                }
                input += (long)ZstdFrameDecompressor.verifyMagic(inputBase, input, inputLimit);
                this.state = State.READ_FRAME_HEADER;
            }
            if (this.state == State.READ_FRAME_HEADER) {
                if (inputLimit - input < 1L) {
                    this.inputRequired(inputAddress, outputOffset, input, output, 1);
                    return;
                }
                int frameHeaderSize = ZstdIncrementalFrameDecompressor.determineFrameHeaderSize(inputBase, input, inputLimit);
                if (inputLimit - input < (long)frameHeaderSize) {
                    this.inputRequired(inputAddress, outputOffset, input, output, frameHeaderSize);
                    return;
                }
                this.frameHeader = ZstdFrameDecompressor.readFrameHeader(inputBase, input, inputLimit);
                Util.verify((long)frameHeaderSize == this.frameHeader.headerSize, input, "Unexpected frame header size");
                input += (long)frameHeaderSize;
                this.state = State.READ_BLOCK_HEADER;
                this.reset();
                if (this.frameHeader.hasChecksum) {
                    this.partialHash = new XxHash64();
                }
            } else {
                Util.verify(this.frameHeader != null, input, "Frame header is not set");
            }
            if (this.state == State.READ_BLOCK_HEADER) {
                long inputBufferSize = inputLimit - input;
                if (inputBufferSize < 3L) {
                    this.inputRequired(inputAddress, outputOffset, input, output, 3);
                    return;
                }
                if (inputBufferSize >= 4L) {
                    this.blockHeader = UnsafeUtil.UNSAFE.getInt(inputBase, input) & 0xFFFFFF;
                } else {
                    this.blockHeader = UnsafeUtil.UNSAFE.getByte(inputBase, input) & 0xFF | (UnsafeUtil.UNSAFE.getByte(inputBase, input + 1L) & 0xFF) << 8 | (UnsafeUtil.UNSAFE.getByte(inputBase, input + 2L) & 0xFF) << 16;
                    int expected = UnsafeUtil.UNSAFE.getInt(inputBase, input) & 0xFFFFFF;
                    Util.verify(this.blockHeader == expected, input, "oops");
                }
                input += 3L;
                this.state = State.READ_BLOCK;
            } else {
                Util.verify(this.blockHeader != -1, input, "Block header is not set");
            }
            boolean bl = lastBlock = (this.blockHeader & 1) != 0;
            if (this.state == State.READ_BLOCK) {
                int decodedSize;
                int blockType = this.blockHeader >>> 1 & 3;
                int blockSize = this.blockHeader >>> 3 & 0x1FFFFF;
                this.resizeWindowBufferIfNecessary(this.frameHeader, blockType, blockSize);
                switch (blockType) {
                    case 0: {
                        if (inputLimit - input < (long)blockSize) {
                            this.inputRequired(inputAddress, outputOffset, input, output, blockSize);
                            return;
                        }
                        Util.verify(this.windowLimit - this.windowPosition >= (long)blockSize, input, "window buffer is too small");
                        decodedSize = ZstdFrameDecompressor.decodeRawBlock(inputBase, input, blockSize, this.windowBase, this.windowPosition, this.windowLimit);
                        input += (long)blockSize;
                        break;
                    }
                    case 1: {
                        if (inputLimit - input < 1L) {
                            this.inputRequired(inputAddress, outputOffset, input, output, 1);
                            return;
                        }
                        Util.verify(this.windowLimit - this.windowPosition >= (long)blockSize, input, "window buffer is too small");
                        decodedSize = ZstdFrameDecompressor.decodeRleBlock(blockSize, inputBase, input, this.windowBase, this.windowPosition, this.windowLimit);
                        ++input;
                        break;
                    }
                    case 2: {
                        if (inputLimit - input < (long)blockSize) {
                            this.inputRequired(inputAddress, outputOffset, input, output, blockSize);
                            return;
                        }
                        Util.verify(this.windowLimit - this.windowPosition >= 131072L, input, "window buffer is too small");
                        decodedSize = this.frameDecompressor.decodeCompressedBlock(inputBase, input, blockSize, this.windowBase, this.windowPosition, this.windowLimit, this.frameHeader.windowSize, this.windowAddress);
                        input += (long)blockSize;
                        break;
                    }
                    default: {
                        throw Util.fail(input, "Invalid block type");
                    }
                }
                this.windowPosition += (long)decodedSize;
                this.state = lastBlock ? State.READ_BLOCK_CHECKSUM : State.READ_BLOCK_HEADER;
            }
            if (this.state != State.READ_BLOCK_CHECKSUM) continue;
            if (this.frameHeader.hasChecksum) {
                if (inputLimit - input < 4L) {
                    this.inputRequired(inputAddress, outputOffset, input, output, 4);
                    return;
                }
                int checksum = UnsafeUtil.UNSAFE.getInt(inputBase, input);
                input += 4L;
                Util.checkState(this.partialHash != null, "Partial hash not set");
                int pendingOutputSize = Math.toIntExact(this.windowPosition - this.windowAddress);
                this.partialHash.update(this.windowBase, Math.toIntExact(this.windowAddress - (long)Unsafe.ARRAY_BYTE_BASE_OFFSET), pendingOutputSize);
                long hash = this.partialHash.hash();
                if (checksum != (int)hash) {
                    throw new MalformedInputException(input, String.format("Bad checksum. Expected: %s, actual: %s", Integer.toHexString(checksum), Integer.toHexString((int)hash)));
                }
            }
            this.state = State.READ_FRAME_MAGIC;
            this.frameHeader = null;
            this.blockHeader = -1;
        }
    }

    private void reset() {
        this.frameDecompressor.reset();
        this.windowAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET;
        this.windowPosition = Unsafe.ARRAY_BYTE_BASE_OFFSET;
    }

    private int computeFlushableOutputSize(FrameHeader frameHeader) {
        return Math.max(0, Math.toIntExact(this.windowPosition - this.windowAddress - (long)(frameHeader == null ? 0 : frameHeader.computeRequiredOutputBufferLookBackSize())));
    }

    private void resizeWindowBufferIfNecessary(FrameHeader frameHeader, int blockType, int blockSize) {
        int maxBlockOutput = blockType == 0 || blockType == 1 ? blockSize : 131072;
        if (this.windowLimit - this.windowPosition < 131072L) {
            int requiredWindowSize = frameHeader.computeRequiredOutputBufferLookBackSize();
            Util.checkState(this.windowPosition - this.windowAddress <= (long)requiredWindowSize, "Expected output to be flushed");
            int windowContentsSize = Math.toIntExact(this.windowPosition - this.windowAddress);
            if (this.windowAddress != (long)Unsafe.ARRAY_BYTE_BASE_OFFSET) {
                System.arraycopy(this.windowBase, Math.toIntExact(this.windowAddress - (long)Unsafe.ARRAY_BYTE_BASE_OFFSET), this.windowBase, 0, windowContentsSize);
                this.windowAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET;
                this.windowPosition = this.windowAddress + (long)windowContentsSize;
            }
            Util.checkState(this.windowAddress == (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, "Window should be packed");
            if (this.windowLimit - this.windowPosition < (long)maxBlockOutput) {
                int newWindowSize;
                if (frameHeader.contentSize >= 0L && frameHeader.contentSize < (long)requiredWindowSize) {
                    newWindowSize = Math.toIntExact(frameHeader.contentSize);
                } else {
                    newWindowSize = (windowContentsSize + maxBlockOutput) * 2;
                    newWindowSize = Math.min(newWindowSize, Math.max(requiredWindowSize, 131072) * 4);
                    newWindowSize = Math.min(newWindowSize, 0x820000);
                    Util.checkState(windowContentsSize + maxBlockOutput <= (newWindowSize = Math.max(windowContentsSize + maxBlockOutput, newWindowSize)), "Computed new window size buffer is not large enough");
                }
                this.windowBase = Arrays.copyOf(this.windowBase, newWindowSize);
                this.windowLimit = newWindowSize + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            }
            Util.checkState(this.windowLimit - this.windowPosition >= (long)maxBlockOutput, "window buffer is too small");
        }
    }

    private static int determineFrameHeaderSize(Object inputBase, long inputAddress, long inputLimit) {
        Util.verify(inputAddress < inputLimit, inputAddress, "Not enough input bytes");
        int frameHeaderDescriptor = UnsafeUtil.UNSAFE.getByte(inputBase, inputAddress) & 0xFF;
        boolean singleSegment = (frameHeaderDescriptor & 0x20) != 0;
        int dictionaryDescriptor = frameHeaderDescriptor & 3;
        int contentSizeDescriptor = frameHeaderDescriptor >>> 6;
        return 1 + (singleSegment ? 0 : 1) + (dictionaryDescriptor == 0 ? 0 : 1 << dictionaryDescriptor - 1) + (contentSizeDescriptor == 0 ? (singleSegment ? 1 : 0) : 1 << contentSizeDescriptor);
    }

    private void requestOutput(long inputAddress, int outputOffset, long input, int output, int requestedOutputSize) {
        this.updateInputOutputState(inputAddress, outputOffset, input, output);
        Util.checkArgument(requestedOutputSize >= 0, "requestedOutputSize is negative");
        this.requestedOutputSize = requestedOutputSize;
        this.inputRequired = 0;
    }

    private void inputRequired(long inputAddress, int outputOffset, long input, int output, int inputRequired) {
        this.updateInputOutputState(inputAddress, outputOffset, input, output);
        Util.checkState(inputRequired >= 0, "inputRequired is negative");
        this.inputRequired = inputRequired;
        this.requestedOutputSize = 0;
    }

    private void updateInputOutputState(long inputAddress, int outputOffset, long input, int output) {
        this.inputConsumed = (int)(input - inputAddress);
        Util.checkState(this.inputConsumed >= 0, "inputConsumed is negative");
        this.outputBufferUsed = output - outputOffset;
        Util.checkState(this.outputBufferUsed >= 0, "outputBufferUsed is negative");
    }

    private static enum State {
        INITIAL,
        READ_FRAME_MAGIC,
        READ_FRAME_HEADER,
        READ_BLOCK_HEADER,
        READ_BLOCK,
        READ_BLOCK_CHECKSUM,
        FLUSH_OUTPUT;

    }
}

