/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.org.bouncycastle.asn1.x509;

import net.snowflake.ingest.internal.org.bouncycastle.asn1.ASN1Encodable;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.ASN1EncodableVector;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.ASN1Object;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.ASN1Primitive;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.ASN1Sequence;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.DERIA5String;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.DERSequence;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.x509.PolicyQualifierId;

public class PolicyQualifierInfo
extends ASN1Object {
    private ASN1ObjectIdentifier policyQualifierId;
    private ASN1Encodable qualifier;

    public PolicyQualifierInfo(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.policyQualifierId = aSN1ObjectIdentifier;
        this.qualifier = aSN1Encodable;
    }

    public PolicyQualifierInfo(String string) {
        this.policyQualifierId = PolicyQualifierId.id_qt_cps;
        this.qualifier = new DERIA5String(string);
    }

    public PolicyQualifierInfo(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        this.policyQualifierId = ASN1ObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        this.qualifier = aSN1Sequence.getObjectAt(1);
    }

    public static PolicyQualifierInfo getInstance(Object object) {
        if (object instanceof PolicyQualifierInfo) {
            return (PolicyQualifierInfo)object;
        }
        if (object != null) {
            return new PolicyQualifierInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ASN1ObjectIdentifier getPolicyQualifierId() {
        return this.policyQualifierId;
    }

    public ASN1Encodable getQualifier() {
        return this.qualifier;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add(this.policyQualifierId);
        aSN1EncodableVector.add(this.qualifier);
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        return "PolicyQualifierInfo[" + this.policyQualifierId + ", " + this.qualifier + "]";
    }
}

